#!/system/bin/sh
#---------------------------------------------
# Yank555.lu - Kernel options script generator
#---------------------------------------------

script_path="/tmp/Yank555.lu/script"
script_name="init.kernel.sh"
log_file="/data/kernel-script.log"
sub_scripts_path="$script_path/sub-scripts"
props_path="/tmp/aroma"

# Start making the script header -----------------------------------------------------------------

echo "----------------------------------------------------" >$log_file
echo "Kernel options init.d script generator by Yank555.lu" >>$log_file
echo "----------------------------------------------------" >>$log_file
date "+Script generated on %d/%m/%Y at %k:%M" >>$log_file
echo "----------------------------------------------------" >>$log_file
echo "" >>$log_file
echo "Preparing init.d script header" >>$log_file

rm $script_path/$script_name >>$log_file
cp $sub_scripts_path/header $script_path/$script_name >>$log_file
date "+# Script generated on %d/%m/%Y at %k:%M" >>$script_path/$script_name
echo "#----------------------------------------------------" >>$script_path/$script_name
echo "" >>$script_path/$script_name

# Add init.d configuration -----------------------------------------------------------------------

echo "" >>$log_file
echo "init.d support configuration" >>$log_file

if [ "`grep selected.1 $props_path/initd.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     init.d support = `grep selected.1 $props_path/initd.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/initd/1.`grep selected.1 $props_path/initd.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
    if [ ! -e /system/etc/init.d ] ; then
        mkdir /system/etc/init.d
        chgrp 2000 /system/etc/init.d
        chmod 755 /system/etc/init.d
        echo "     (init.d folder created)" >>$log_file
    fi
fi;

# Add CPU configuration --------------------------------------------------------------------------

echo "" >>$log_file
echo "CPU configuration" >>$log_file

if [ "`grep selected.1 $props_path/cpu.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     CPU max freq. = `grep selected.1 $props_path/cpu.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/cpu/1.`grep selected.1 $props_path/cpu.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.2 $props_path/cpu.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     CPU Governor  = `grep selected.2 $props_path/cpu.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/cpu/2.`grep selected.2 $props_path/cpu.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Virtual memory configuration -------------------------------------------------------------------

echo "" >>$log_file
echo "Virtual memory configuration" >>$log_file

if [ "`grep selected.2 $props_path/swap.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Zram       = `grep selected.2 $props_path/swap.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/swap/2.`grep selected.2 $props_path/swap.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.1 $props_path/swap.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Hardswap   = `grep selected.1 $props_path/swap.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/swap/1.`grep selected.1 $props_path/swap.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.3 $props_path/swap.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Swappiness = `grep selected.3 $props_path/swap.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/swap/3.`grep selected.3 $props_path/swap.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Fast charge configuration ----------------------------------------------------------------------

echo "" >>$log_file
echo "Fast charge configuration" >>$log_file

if [ "`grep selected.1 $props_path/charge.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Mode = `grep selected.1 $props_path/charge.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/charge/1.`grep selected.1 $props_path/charge.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.2 $props_path/charge.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     USB  = `grep selected.2 $props_path/charge.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/charge/2.`grep selected.2 $props_path/charge.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.3 $props_path/charge.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     AC   = `grep selected.3 $props_path/charge.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/charge/3.`grep selected.3 $props_path/charge.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# CRT off delay ----------------------------------------------------------------------------------

echo "" >>$log_file
echo "CRT off animation delay" >>$log_file

if [ "`grep selected.1 $props_path/earlysuspend.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Delay = `grep selected.1 $props_path/earlysuspend.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/earlysuspend/1.`grep selected.1 $props_path/earlysuspend.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Boeffla Sound Engine ---------------------------------------------------------------------------

echo "" >>$log_file
echo "Sound output level configuration" >>$log_file

if [ "`grep selected.1 $props_path/boeffla.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Master Switch      = `grep selected.1 $props_path/boeffla.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/boeffla/1.`grep selected.1 $props_path/boeffla.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.1 $props_path/boeffla.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Speaker Output     = `grep selected.2 $props_path/boeffla.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/boeffla/2.`grep selected.2 $props_path/boeffla.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.1 $props_path/boeffla.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Headphones Output  = `grep selected.3 $props_path/boeffla.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/boeffla/3.`grep selected.3 $props_path/boeffla.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.1 $props_path/boeffla.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Equalizer Mode     = `grep selected.4 $props_path/boeffla.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/boeffla/4.`grep selected.4 $props_path/boeffla.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.1 $props_path/boeffla.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Equalizer Setting  = `grep selected.5 $props_path/boeffla.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/boeffla/5.`grep selected.5 $props_path/boeffla.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.1 $props_path/boeffla.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Privacy Mode       = `grep selected.6 $props_path/boeffla.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/boeffla/6.`grep selected.6 $props_path/boeffla.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.1 $props_path/boeffla.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     DAC direct         = `grep selected.7 $props_path/boeffla.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/boeffla/7.`grep selected.7 $props_path/boeffla.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.1 $props_path/boeffla.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     DAC 128bit ov.samp.= `grep selected.8 $props_path/boeffla.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/boeffla/8.`grep selected.8 $props_path/boeffla.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.1 $props_path/boeffla.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     FLL clock tuning   = `grep selected.9 $props_path/boeffla.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/boeffla/9.`grep selected.9 $props_path/boeffla.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.1 $props_path/boeffla.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Mic. Sensitivity   = `grep selected.10 $props_path/boeffla.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/boeffla/10.`grep selected.10 $props_path/boeffla.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Add fsync configuration ------------------------------------------------------------------------

echo "" >>$log_file
echo "fsync support configuration" >>$log_file

if [ "`grep selected.1 $props_path/fsync.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     fsync support = `grep selected.1 $props_path/fsync.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/fsync/1.`grep selected.1 $props_path/fsync.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Add kernel modules loading on boot -------------------------------------------------------------

echo "" >>$log_file
echo "Kernel modules loading on boot" >>$log_file

if [ "`grep selected.1 $props_path/modules.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     cifs kernel modules = `grep selected.1 $props_path/modules.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/modules/1.`grep selected.1 $props_path/modules.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.2 $props_path/modules.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     xpad kernel modules = `grep selected.2 $props_path/modules.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/modules/2.`grep selected.2 $props_path/modules.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Add MMC I/O configuration ----------------------------------------------------------------------

echo "" >>$log_file
echo "MMC I/O configuration" >>$log_file

if [ "`grep selected.1 $props_path/io.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     ReadAhead size  = `grep selected.1 $props_path/io.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/io/1.`grep selected.1 $props_path/io.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.2 $props_path/io.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     I/O scheduler   = `grep selected.2 $props_path/io.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/io/2.`grep selected.2 $props_path/io.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Add Android Low Memory Killer configuration ----------------------------------------------------

echo "" >>$log_file
echo "Android Low Memory Killer configuration" >>$log_file

if [ "`grep selected.1 $props_path/lmk.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Android LMK = `grep selected.1 $props_path/lmk.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/lmk/1.`grep selected.1 $props_path/lmk.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

cat $sub_scripts_path/footer >>$script_path/$script_name

# Installing generated script to system init -----------------------------------------------------

echo "" >>$log_file
echo "Installing generated script to /system/etc" >>$log_file

rm /system/etc/$script_name
cp $script_path/$script_name /system/etc/$script_name
chmod 755 /system/etc/$script_name
chown 0:2000 /system/etc/$script_name

# All done for this step -------------------------------------------------------------------------