#!/system/bin/sh
#----------------------------------------------------
# Yank555.lu - Kernel options init.d script generator
#----------------------------------------------------

script_path="/tmp/Yank555.lu/script"
script_name="init.kernel.sh"
log_file="/data/kernel-script.log"
sub_scripts_path="$script_path/sub-scripts"
props_path="/tmp/aroma"

# Start making the script header -----------------------------------------------------------------

echo "----------------------------------------------------" >$log_file
echo "Kernel options init.d script generator by Yank555.lu" >>$log_file
echo "----------------------------------------------------" >>$log_file
date "+Script generated on %d/%m/%Y at %k:%M" >>$log_file
echo "----------------------------------------------------" >>$log_file
echo "" >>$log_file
echo "1) Preparing init.d script header" >>$log_file

rm $script_path/$script_name >>$log_file
cp $sub_scripts_path/header $script_path/$script_name >>$log_file
date "+# Script generated on %d/%m/%Y at %k:%M" >>$script_path/$script_name
echo "#----------------------------------------------------" >>$script_path/$script_name
echo "" >>$script_path/$script_name

# Add init.d configuration -----------------------------------------------------------------------

echo "" >>$log_file
echo "2) init.d support configuration" >>$log_file

if [ "`grep selected.1 $props_path/initd.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     init.d support = `grep selected.1 $props_path/initd.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/initd/1.`grep selected.1 $props_path/initd.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Add CPU configuration --------------------------------------------------------------------------

echo "" >>$log_file
echo "3) CPU configuration" >>$log_file

if [ "`grep selected.1 $props_path/cpu.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     CPU max freq. = `grep selected.1 $props_path/cpu.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/cpu/1.`grep selected.1 $props_path/cpu.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.2 $props_path/cpu.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     IO is busy    = `grep selected.2 $props_path/cpu.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/cpu/2.`grep selected.2 $props_path/cpu.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Virtual memory configuration -------------------------------------------------------------------

echo "" >>$log_file
echo "4) Virtual memory configuration" >>$log_file

if [ "`grep selected.2 $props_path/swap.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Zram     = `grep selected.2 $props_path/swap.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/swap/2.`grep selected.2 $props_path/swap.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.1 $props_path/swap.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Hardswap = `grep selected.1 $props_path/swap.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/swap/1.`grep selected.1 $props_path/swap.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Fast charge configuration ----------------------------------------------------------------------

echo "" >>$log_file
echo "5) Fast charge configuration" >>$log_file

if [ "`grep selected.1 $props_path/charge.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Mode = `grep selected.1 $props_path/charge.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/charge/1.`grep selected.1 $props_path/charge.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.2 $props_path/charge.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     USB  = `grep selected.2 $props_path/charge.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/charge/2.`grep selected.2 $props_path/charge.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.3 $props_path/charge.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     AC   = `grep selected.3 $props_path/charge.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/charge/3.`grep selected.3 $props_path/charge.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Add MMC I/O configuration ----------------------------------------------------------------------

echo "" >>$log_file
echo "6) MMC I/O configuration" >>$log_file

if [ "`grep selected.1 $props_path/io.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     ReadAhead size  = `grep selected.1 $props_path/io.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/io/1.`grep selected.1 $props_path/io.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`grep selected.2 $props_path/io.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     I/O scheduler   = `grep selected.2 $props_path/io.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/io/2.`grep selected.2 $props_path/io.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Add Android Low Memory Killer configuration ----------------------------------------------------

echo "" >>$log_file
echo "7) Android Low Memory Killer configuration" >>$log_file

if [ "`grep selected.1 $props_path/lmk.prop | awk -F= '{print $2;}'`" != "" ]
  then
    echo "     Android LMK = `grep selected.1 $props_path/lmk.prop | awk -F= '{print $2;}'`" >>$log_file
    cat $sub_scripts_path/lmk/1.`grep selected.1 $props_path/lmk.prop | awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

cat $sub_scripts_path/footer >>$script_path/$script_name

# Installing generated script to system init -----------------------------------------------------

echo "" >>$log_file
echo "8) Installing generated script to /system/etc" >>$log_file

rm /system/etc/$script_name
cp $script_path/$script_name /system/etc/$script_name
chmod 755 /system/etc/$script_name
chown 0:2000 /system/etc/$script_name

# All done for this step -------------------------------------------------------------------------