/*
 * es325-access.h  --  ES325 Soc Audio access values
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef _ES325_ACCESS_H
#define _ES325_ACCESS_H

#define ES325_API_WORD(upper, lower) ((upper << 16) | lower)

static struct es325_api_access es325_api_access[ES325_API_ADDR_MAX] = {
	[ES325_MIC_CONFIG] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0002) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0002),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AEC_MODE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0003) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0003),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_AGC] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0004) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0004),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_AGC_TARGET_LEVEL] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0005) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0005),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_AGC_NOISE_FLOOR] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0006) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0006),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_AGC_SNR_IMPROVEMENT] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0007) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0007),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_VEQ_ENABLE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0009) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0009),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_OUT_LIMITER_MAX_LEVEL] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x000d) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x000d),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_NOISE_SUPPRESS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x000e) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x000e),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_STS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0010) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0010),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_STS_RATE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0011) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0011),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AEC_SPEAKER_VOLUME] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0012) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0012),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIDETONE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0015) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0015),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIDETONE_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0016) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0016),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_COMFORT_NOISE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x001a) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x001a),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_COMFORT_NOISE_LEVEL] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x001b) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x001b),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_ALGORITHM_RESET] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x001c) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x001c),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_POST_EQ] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x001f) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x001f),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_POST_EQ] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0020) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0020),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AEC_CNG] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0023) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0023),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_VEQ_NOISE_ESTIMATION_ADJUSTMENT] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0024) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0024),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_AGC_SLEW_RATE_UP] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0026) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0026),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_AGC_SLEW_RATE_DOWN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0027) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0027),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_AGC] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0028) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0028),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_AGC_TARGET_LEVEL] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0029) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0029),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_AGC_NOISE_FLOOR] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x002a) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x002a),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_AGC_SNR_IMPROVEMENT] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x002b) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x002b),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_AGC_SLEW_RATE_UP] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x002c) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x002c),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_AGC_SLEW_RATE_DOWN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x002d) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x002d),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AEC_CNG_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x002e) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x002e),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_MBC] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0030) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0030),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_MBC] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0031) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0031),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AEC_ESE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0034) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0034),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_NS_ADAPTATION_SPEED] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0039) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0039),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_SNR_ESTIMATE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x003a) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x003a),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_VEQ_MAX_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x003d) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x003d),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_AGC_GUARDBAND] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x003e) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x003e),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_AGC_GUARDBAND] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x003f) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x003f),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_OUT_LIMITER_MAX_LEVEL] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0040) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0040),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_IN_LIMITER_MAX_LEVEL] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0042) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0042),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_NS_ADAPTATION_SPEED] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0043) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0043),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AEC_VARIABLE_ECHO_REF_DELAY] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0047) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0047),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_NOISE_SUPPRESS_LEVEL] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x004b) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x004b),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_NOISE_SUPPRESS_LEVEL] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x004c) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x004c),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_CNG] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x004d) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x004d),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_CNG_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x004e) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x004e),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TX_AGC_MAX_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0100) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0100),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_RX_AGC_MAX_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0102) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0102),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_API_VERSION_LO] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1001) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1001),
			ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_API_VERSION_HI] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1002) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1002),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_AV_PROCESSOR] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1003) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1003),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_AV_CONFIG] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1003) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1003),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_EQ_PRESET] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1005) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1005),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_STEREO_WIDTH] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1006) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1006),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_AV_DIGITAL_OUT_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1007) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1007),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_TDMBC] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1008) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1008),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_AV_OUT_LIMIT] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1009) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1009),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_STEREO_WIDENING] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x100a) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x100a),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_STAT_NS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x100b) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x100b),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_STAT_NS_SUPPRESS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x100c) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x100c),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_STAT_NS_ADAP_SPEED] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x100d) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x100d),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_STAT_NS_MODE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x100e) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x100e),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVLALON_STAT_NS_MAX_NOISE_ENERGY] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x100f) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x100f),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_VBB] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1010) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1010),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_VBB_STRENGTH] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1011) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1011),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_EQ_MODE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1012) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1012),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_EQ_GRAPHIC_BAND1_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1013) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1013),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_EQ_GRAPHIC_BAND2_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1014) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1014),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_EQ_GRAPHIC_BAND3_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1015) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1015),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_EQ_GRAPHIC_BAND4_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1016) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1016),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_EQ_GRAPHIC_BAND5_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1017) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1017),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_EQ_GRAPHIC_BAND6_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1018) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1018),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_EQ_GRAPHIC_BAND7_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1019) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1019),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_EQ_GRAPHIC_BAND8_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x101a) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x101a),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_EQ_GRAPHIC_BAND9_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x101b) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x101b),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_EQ_GRAPHIC_BAND10_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x101c) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x101c),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_TDDRC] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x101d) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x101d),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_TDDRC_STRENGTH] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x101e) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x101e),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_LIMITER] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x101f) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x101f),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_AVALON_EQ] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x1020) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x1020),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2000),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_OUT_HEADROOM_LIMITER] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2001) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2001),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_MODE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2002) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2002),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_IN_HEADROOM_LIMITER] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2004) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2004),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_COMFORT_NOISE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2006) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2006),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_COMFORT_NOISE_LEVEL] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2007) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2007),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_NARRATOR_VQOS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2008) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2008),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_NARRATOR_POSITION_SUPPRESS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2009) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2009),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_NARRATOR_AGC_OUT] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x200a) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x200a),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_NARRATOR_AGC_SPEECH_TARGET] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x200b) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x200b),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_NARRATOR_AGC_SNR_IMPROVE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x200c) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x200c),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_NARRATOR_AGC_NOISE_FLOOR] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x200d) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x200d),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_NARRATOR_AGC_MAX_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x200e) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x200e),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_NARRATOR_AGC_UP_RATE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x200f) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x200f),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_NARRATOR_AGC_DOWN_RATE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2010) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2010),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_NARRATOR_AGC_GUARDBAND] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2011) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2011),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_NARRATOR_POST_EQ_MODE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2013) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2013),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_NARRATOR_MBC_MODE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2014) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2014),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_SCENE_BEAM_WIDTH] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2015) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2015),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_SCENE_AGC_OUT] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2016) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2016),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_SCENE_AGC_SPEECH_TARGET] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2017) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2017),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_SCENE_AGC_SNR_IMPROVE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2018) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2018),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_SCENE_AGC_NOISE_FLOOR] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2019) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2019),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_SCENE_AGC_MAX_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x201a) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x201a),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_SCENE_AGC_UP_RATE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x201b) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x201b),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_SCENE_AGC_DOWN_RATE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x201c) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x201c),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_SCENE_AGC_GUARDBAND] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x201d) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x201d),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_SCENE_VQOS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x201f) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x201f),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_SCENE_POST_EQ_MODE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2020) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2020),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIRAC_SCENE_MBC_MODE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x2021) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x2021),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TONE_PARAM_API_VERSION_LO] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x3001) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x3001),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TONE_PARAM_API_VERSION_HI] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x3002) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x3002),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TONE_PARAM_ENABLE_BEEP_SYS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x3003) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x3003),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TONE_PARAM_ENABLE_GEN_BEEP] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x3005) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x3005),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TONE_PARAM_GEN_BEEP_ON] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x3006) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x3006),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TONE_PARAM_GEN_BEEP_FREQ1] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x3007) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x3007),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TONE_PARAM_GEN_BEEP_FREQ2] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x3008) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x3008),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TONE_PARAM_GEN_BEEP_PAN_LR] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x3009) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x3009),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_TONE_PARAM_GEN_BEEP_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x300a) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x300a),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DEREVERB_ENABLE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0053) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0053),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DEREVERB_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0054) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0054),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_BWE_ENABLE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x004f) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x004f),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_BWE_HIGH_BAND_GAIN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0050) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0050),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_BWE_MAX_SNR] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0051) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0051),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_BWE_POST_EQ_ENABLE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_ALGO_PARAM, 0x0052) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_ALGO_PARAM_ID, 0x0052),
			       ES325_API_WORD(ES325_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTA_WORD_LEN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0a00) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0a00),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTA_TDM_SLOTS_PER_FRAME] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0a01) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0a01),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTA_TX_DELAY_FROM_FS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0a02) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0a02),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTA_RX_DELAY_FROM_FS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0a03) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0a03),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTA_LATCH_EDGE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0a04) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0a04),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTA_ENDIAN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0a05) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0a05),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTA_TRISTATE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0a06) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0a06),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTA_AUDIO_PORT_MODE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0a07) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0a07),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTA_TDM_ENABLED] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0a08) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0a08),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTA_CLOCK_CONTROL] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0a09) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0a09),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTA_DATA_JUSTIFICATION] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0a0a) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0a0a),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTA_FS_DURATION] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0a0b) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0a0b),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTB_WORD_LEN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0b00) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0b00),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTB_TDM_SLOTS_PER_FRAME] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0b01) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0b01),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTB_TX_DELAY_FROM_FS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0b02) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0b02),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTB_RX_DELAY_FROM_FS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0b03) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0b03),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTB_LATCH_EDGE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0b04) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0b04),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTB_ENDIAN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0b05) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0b05),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTB_TRISTATE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0b06) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0b06),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTB_AUDIO_PORT_MODE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0b07) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0b07),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTB_TDM_ENABLED] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0b08) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0b08),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTB_CLOCK_CONTROL] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0b09) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0b09),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTB_DATA_JUSTIFICATION] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0b0a) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0b0a),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTB_FS_DURATION] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0b0b) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0b0b),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTC_WORD_LEN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0c00) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0c00),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTC_TDM_SLOTS_PER_FRAME] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0c01) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0c01),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTC_TX_DELAY_FROM_FS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0c02) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0c02),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTC_RX_DELAY_FROM_FS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0c03) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0c03),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTC_LATCH_EDGE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0c04) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0c04),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTC_ENDIAN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0c05) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0c05),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTC_TRISTATE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0c06) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0c06),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTC_AUDIO_PORT_MODE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0c07) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0c07),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTC_TDM_ENABLED] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0c08) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0c08),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTC_CLOCK_CONTROL] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0c09) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0c09),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTC_DATA_JUSTIFICATION] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0c0a) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0c0a),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTC_FS_DURATION] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0c0b) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0c0b),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTD_WORD_LEN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0d00) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0d00),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTD_TDM_SLOTS_PER_FRAME] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0d01) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0d01),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTD_TX_DELAY_FROM_FS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0d02) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0d02),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTD_RX_DELAY_FROM_FS] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0d03) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0d03),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTD_LATCH_EDGE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0d04) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0d04),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTD_ENDIAN] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0d05) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0d05),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTD_TRISTATE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0d06) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0d06),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTD_AUDIO_PORT_MODE] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0d07) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0d07),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTD_TDM_ENABLED] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0d08) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0d08),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTD_CLOCK_CONTROL] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0d09) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0d09),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTD_DATA_JUSTIFICATION] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0d0a) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0d0a),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_PORTD_FS_DURATION] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0d0b) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0d0b),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SLIMBUS_LINK_MULTI_CHANNEL] = {
		.read_msg = { ES325_API_WORD(ES325_GET_DEV_PARAM, 0x0900) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(ES325_SET_DEV_PARAM_ID, 0x0900),
			       ES325_API_WORD(ES325_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_POWER_STATE] = {
		.read_msg = { ES325_API_WORD(0x8010, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8010, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES325_STREAMING] = {
		.read_msg = { ES325_API_WORD(0x8025, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8025, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 5,
	},
	[ES325_FE_STREAMING] = {
		.read_msg = { ES325_API_WORD(0x8028, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8028, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 8,
	},
	[ES325_PRESET] = {
		.read_msg = { ES325_API_WORD(0x8031, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8031, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 15,
	},
	[ES325_ALGO_STATS] = {
		.read_msg = { ES325_API_WORD(0x8042, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8042, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 15,
	},
	[ES325_ALGO_PROCESSING] = {
		.read_msg = { ES325_API_WORD(0x8043, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x801c, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES325_ALGO_SAMPLE_RATE] = {
		.read_msg = { ES325_API_WORD(0x804b, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x804c, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 5,
	},
	[ES325_SMOOTH_RATE] = {
		.read_msg = { ES325_API_WORD(0x804d, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x804e, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_CHANGE_STATUS] = {
		.read_msg = { ES325_API_WORD(0x804f, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x804f, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 4,
	},
	[ES325_DIGITAL_PASS_THROUGH] = {
		.read_msg = { ES325_API_WORD(0x8052, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8052, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DATA_PATH] = {
		.read_msg = { ES325_API_WORD(0x805b, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x805a, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_ALGORITHM] = {
		.read_msg = { ES325_API_WORD(0x805d, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x805c, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 4,
	},
	[ES325_MIX_SAMPLE_RATE] = {
		.read_msg = { ES325_API_WORD(0x8065, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x805e, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 5,
	},
	[ES325_SIGNAL_RMS_PORTA_DIN_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTA_DIN_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x0001) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x0001) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTA_DOUT_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x0002) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x0002) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTA_DOUT_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x0003) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x0003) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTB_DIN_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x0004) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x0004) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTB_DIN_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x0005) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x0005) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTB_DOUT_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x0006) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x0006) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTB_DOUT_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x0007) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x0007) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTC_DIN_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x0008) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x0008) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTC_DIN_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x0009) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x0009) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTC_DOUT_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x000a) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x000a) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTC_DOUT_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x000b) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x000b) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTD_DIN_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x000c) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x000c) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTD_DIN_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x000d) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x000d) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTD_DOUT_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x000e) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x000e) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_RMS_PORTD_DOUT_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8013, 0x000f) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8013, 0x000f) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTA_DIN_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTA_DIN_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x0001) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x0001) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTA_DOUT_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x0002) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x0002) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTA_DOUT_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x0003) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x0003) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTB_DIN_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x0004) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x0004) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTB_DIN_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x0005) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x0005) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTB_DOUT_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x0006) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x0006) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTB_DOUT_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x0007) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x0007) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTC_DIN_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x0008) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x0008) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTC_DIN_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x0009) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x0009) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTC_DOUT_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x000a) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x000a) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTC_DOUT_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x000b) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x000b) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTD_DIN_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x000c) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x000c) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTD_DIN_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x000d) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x000d) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTD_DOUT_LEFT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x000e) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x000e) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_SIGNAL_PEAK_PORTD_DOUT_RIGHT] = {
		.read_msg = { ES325_API_WORD(0x8014, 0x000f) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8014, 0x000f) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES325_DIGITAL_GAIN_PRIMARY] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0001) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x0100) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_SECONDARY] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0002) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x0200) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_TERTIARY] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0003) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x0300) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_QUAD] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0004) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x0400) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_FEIN] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0005) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x0500) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_AUDIN1] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0006) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x0600) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_AUDIN2] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0007) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x0700) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_AUDIN3] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0008) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x0800) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_AUDIN4] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0009) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x0900) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_UITONE1] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x000A) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x0a00) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_UITONE2] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x000B) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x0b00) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_CSOUT] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0010) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x1000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_FEOUT1] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0011) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x1100) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_FEOUT2] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0012) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x1200) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_AUDOUT1] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0013) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x1300) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_AUDOUT2] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0014) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x1400) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_AUDOUT3] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0015) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x1500) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_DIGITAL_GAIN_AUDOUT4] = {
		.read_msg = { ES325_API_WORD(0x801D, 0x0016) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8015, 0x1600) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_PORTA_TIMING] = {
		.read_msg = { ES325_API_WORD(0x8059, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8058, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 15,
	},
	[ES325_PORTB_TIMING] = {
		.read_msg = { ES325_API_WORD(0x8059, 0x1000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8058, 0x1000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 15,
	},
	[ES325_PORTC_TIMING] = {
		.read_msg = { ES325_API_WORD(0x8059, 0x2000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8058, 0x2000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 15,
	},
	[ES325_PORTD_TIMING] = {
		.read_msg = { ES325_API_WORD(0x8059, 0x3000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8058, 0x3000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 15,
	},
	[ES325_FLUSH] = {
		.read_msg = { ES325_API_WORD(0x805A, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8059, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 0,
	},
	[ES325_FW_FIRST_CHAR] = {
		.read_msg = { ES325_API_WORD(0x8020, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8020, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES325_FW_NEXT_CHAR] = {
		.read_msg = { ES325_API_WORD(0x8021, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES325_API_WORD(0x8021, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
};

#endif /* _ES325_ACCESS_H */
