/*
 * dlog.h
 *
 * header file supporting MDP debug functions for Samsung device
 */
 
#if !defined(__DLOG_H) 
#define __DLOG_H
#define START_MAGIC 0xDEADBABE
#define FUNC_END 0x9999
typedef unsigned int u32;
#include <mach/sec_debug.h>
#if defined(CONFIG_SAMSUNG_DEBUG_DISPLAY)
	#define __DLOG__(...) dlog(0xAAAA,##__VA_ARGS__,0xBABEBABE)
	#define __DLOGE__(...) dlog(0xBBBB,##__VA_ARGS__,0xBABEBABE)
#else
	#define __DLOG__(...)
	#define __DLOGE__(...) 
#endif
#define __DLOG_(...) dlog(0xAAAA,##__VA_ARGS__,0xBABEBABE)

#define CARVEOUT_MEM_SIZE 0x100000
#ifndef __KERNEL__
/* Confirm these values when platform/linux kernel change */
#define TASK_COMM_LEN 16
typedef unsigned int  pid_t;
typedef int atomic_t;
#define SCHED_LOG_MAX 1024  //from sec_debug.h

struct irq_log {
	unsigned long long time;
	int irq;
	unsigned int fn;
	int en;
	int preempt_count;
	unsigned int context;
};

struct irq_exit_log {
	unsigned int irq;
	unsigned long long time;
	unsigned long long end_time;
	unsigned long long elapsed_time;
};

struct sched_log {
	unsigned long long time;
	char comm[TASK_COMM_LEN];
	pid_t pid;
};


struct timer_log {
	unsigned long long time;
	unsigned int type;
	int int_lock;
	unsigned int fn;
};

//Different Sec debug structures for different CPU Counts
struct sec_debug_log1 {
	atomic_t idx_sched[1];
	struct sched_log sched[1][SCHED_LOG_MAX];

	atomic_t idx_irq[1];
	struct irq_log irq[2][SCHED_LOG_MAX];

	atomic_t idx_irq_exit[1];
	struct irq_exit_log irq_exit[1][SCHED_LOG_MAX];

	atomic_t idx_timer[1];
	struct timer_log timer_log[1][SCHED_LOG_MAX];
};


struct sec_debug_log2 {
	atomic_t idx_sched[2];
	struct sched_log sched[2][SCHED_LOG_MAX];

	atomic_t idx_irq[2];
	struct irq_log irq[2][SCHED_LOG_MAX];

	atomic_t idx_irq_exit[2];
	struct irq_exit_log irq_exit[2][SCHED_LOG_MAX];

	atomic_t idx_timer[2];
	struct timer_log timer_log[2][SCHED_LOG_MAX];
};

struct sec_debug_log4 {
	atomic_t idx_sched[2];
	struct sched_log sched[2][SCHED_LOG_MAX];

	atomic_t idx_irq[2];
	struct irq_log irq[2][SCHED_LOG_MAX];

	atomic_t idx_irq_exit[2];
	struct irq_exit_log irq_exit[2][SCHED_LOG_MAX];

	atomic_t idx_timer[2];
	struct timer_log timer_log[2][SCHED_LOG_MAX];
};

struct sec_debug_log8 {
	atomic_t idx_sched[2];
	struct sched_log sched[2][SCHED_LOG_MAX];

	atomic_t idx_irq[2];
	struct irq_log irq[2][SCHED_LOG_MAX];

	atomic_t idx_irq_exit[2];
	struct irq_exit_log irq_exit[2][SCHED_LOG_MAX];

	atomic_t idx_timer[2];
	struct timer_log timer_log[2][SCHED_LOG_MAX];
};

#else
#ifdef CONFIG_SEC_DEBUG_SCHED_LOG

//Copy defination from sec_debug file
struct sec_debug_log {
	atomic_t idx_sched[CONFIG_NR_CPUS];
	struct sched_log sched[CONFIG_NR_CPUS][SCHED_LOG_MAX];

	atomic_t idx_irq[CONFIG_NR_CPUS];
	struct irq_log irq[CONFIG_NR_CPUS][SCHED_LOG_MAX];

	atomic_t idx_irq_exit[CONFIG_NR_CPUS];
	struct irq_exit_log irq_exit[CONFIG_NR_CPUS][SCHED_LOG_MAX];

	atomic_t idx_timer[CONFIG_NR_CPUS];
	struct timer_log timer_log[CONFIG_NR_CPUS][SCHED_LOG_MAX];

#ifdef CONFIG_SEC_DEBUG_MSG_LOG
	atomic_t idx_secmsg[CONFIG_NR_CPUS];
	struct secmsg_log secmsg[CONFIG_NR_CPUS][MSG_LOG_MAX];
#endif
#ifdef CONFIG_SEC_DEBUG_DCVS_LOG
	atomic_t dcvs_log_idx ;
	struct dcvs_debug dcvs_log[DCVS_LOG_MAX] ;
#endif
#ifdef CONFIG_SEC_DEBUG_FUELGAUGE_LOG
	atomic_t fg_log_idx;
	struct fuelgauge_debug fg_log[FG_LOG_MAX] ;
#endif
};
#endif
#endif


#if !defined(__DLOG_IMPLEMENTAION_MODULE__) &&  defined(CONFIG_SAMSUNG_DEBUG_DISPLAY)
#undef pr_debug
#undef pr_err
#undef pr_notice
#undef pr_info
#undef pr_warning

#if defined(DLOG_USER_VARIANT)

#if defined(CONFIG_SEC_DEBUG_SCHED_LOG)
#define pr_debug(fmt,...) \
		do{	 	if(kernel_sec_get_debug_level() == KERNEL_SEC_DEBUG_LEVEL_HIGH )  __DLOG__(__VA_ARGS__);\
			 dynamic_pr_debug(fmt, ##__VA_ARGS__);} while(0)
#else
#define pr_debug(fmt,...) \
		do{	 __DLOG__(__VA_ARGS__);\
			 dynamic_pr_debug(fmt, ##__VA_ARGS__);} while(0)
#endif

#define pr_err(fmt,...) \
		do{  __DLOGE__(__VA_ARGS__);\
		printk(KERN_ERR pr_fmt(fmt), ##__VA_ARGS__);} while(0)

#define pr_warning(fmt, ...) \
		do{__DLOG__(__VA_ARGS__);\
        printk(KERN_WARNING pr_fmt(fmt), ##__VA_ARGS__);} while(0)

#define pr_notice(fmt, ...) \
		do{__DLOG__(__VA_ARGS__);\
        printk(KERN_NOTICE pr_fmt(fmt), ##__VA_ARGS__);} while(0)

#define pr_info(fmt, ...) \
		do{   __DLOG__(__VA_ARGS__);\
        printk(KERN_INFO pr_fmt(fmt), ##__VA_ARGS__);} while(0)
#else
#define pr_debug(fmt,...) \
	do{	__DLOG__(__VA_ARGS__);\
			 dynamic_pr_debug(fmt, ##__VA_ARGS__);} while(0)

#define pr_err(fmt,...) \
		do{__DLOGE__(__VA_ARGS__);\
		printk(KERN_ERR pr_fmt(fmt), ##__VA_ARGS__);} while(0)

#define pr_warning(fmt, ...) \
		do{__DLOGE__(__VA_ARGS__);\
        printk(KERN_WARNING pr_fmt(fmt), ##__VA_ARGS__);} while(0)

#define pr_notice(fmt, ...) \
		do{__DLOG__(__VA_ARGS__);\
        printk(KERN_NOTICE pr_fmt(fmt), ##__VA_ARGS__);} while(0)

#define pr_info(fmt, ...) \
		do{__DLOG__(__VA_ARGS__);\
       printk(KERN_INFO pr_fmt(fmt), ##__VA_ARGS__);} while(0)

#endif
#endif
//#define __DLOG_(...) dlog(0xAAAA,__VA_ARGS__,0xBABEBABE);
void dlog(u32 eventid, ...);
void klog(void);
void dump_event_code(void);
void dump_mdp_stats(void);
void dump_overlay_stats(void);
void dump_gpio_state(void);
void dump_clock_state(void);
struct buffer_meta {
	u32 first;
	u32 last;
	u32 offset;
	u32 len;
};

struct dump_event {
	u32 ret_address;
	char func_name[60];
};

struct reg_desc{
	u32 base;
	int len;
	u32 vaddr;
};

struct debug_mdp {
	char marker[32]; 
	u32 size;
	u32 klog_size;
	u32 seclog_size;
	u32 reserv;
	struct buffer_meta log_buff;
	struct buffer_meta event_desc;
	struct buffer_meta reg_log;
	struct buffer_meta mdp_stats;
	struct buffer_meta overlay_stats;
	struct buffer_meta panel_state;
	struct buffer_meta regulator_state;
	struct buffer_meta clock_state;
 };

struct dclock {
	 char name[24]; //Keep in multiples of 4
	 u32 reg_addr;
	 u32 test_reg;
	 u32 vreg_addr;
};

//Clock Registers
#define HWIO_GCC_BAM_DMA_AHB_CBCR_ADDR 0xfc400d44
#define HWIO_GCC_BAM_DMA_INACTIVITY_TIMERS_CBCR_ADDR 0xfc400d48
#define HWIO_GCC_BIMC_CFG_AHB_CBCR_ADDR 0xfc40110c
#define HWIO_GCC_BIMC_CBCR_ADDR 0xfc401118
#define HWIO_GCC_BIMC_KPSS_AXI_CBCR_ADDR 0xfc40111c
#define HWIO_GCC_BIMC_SLEEP_CBCR_ADDR 0xfc401110
#define HWIO_GCC_BIMC_SYSNOC_AXI_CBCR_ADDR 0xfc401114
#define HWIO_GCC_BIMC_XO_CBCR_ADDR 0xfc401108
#define HWIO_GCC_BLSP1_AHB_CBCR_ADDR 0xfc4005c4
#define HWIO_GCC_BLSP1_SLEEP_CBCR_ADDR 0xfc4005c8
#define HWIO_GCC_BLSP1_QUP1_I2C_APPS_CBCR_ADDR 0xfc400648
#define HWIO_GCC_BLSP1_QUP1_SPI_APPS_CBCR_ADDR 0xfc400644
#define HWIO_GCC_BLSP1_QUP2_I2C_APPS_CBCR_ADDR 0xfc4006c8
#define HWIO_GCC_BLSP1_QUP2_SPI_APPS_CBCR_ADDR 0xfc4006c4
#define HWIO_GCC_BLSP1_QUP3_I2C_APPS_CBCR_ADDR 0xfc400748
#define HWIO_GCC_BLSP1_QUP3_SPI_APPS_CBCR_ADDR 0xfc400744
#define HWIO_GCC_BLSP1_QUP4_I2C_APPS_CBCR_ADDR 0xfc4007c8
#define HWIO_GCC_BLSP1_QUP4_SPI_APPS_CBCR_ADDR 0xfc4007c4
#define HWIO_GCC_BLSP1_QUP5_I2C_APPS_CBCR_ADDR 0xfc400848
#define HWIO_GCC_BLSP1_QUP5_SPI_APPS_CBCR_ADDR 0xfc400844
#define HWIO_GCC_BLSP1_QUP6_I2C_APPS_CBCR_ADDR 0xfc4008c8
#define HWIO_GCC_BLSP1_QUP6_SPI_APPS_CBCR_ADDR 0xfc4008c4
#define HWIO_GCC_BLSP1_UART1_APPS_CBCR_ADDR 0xfc400684
#define HWIO_GCC_BLSP1_UART1_SIM_CBCR_ADDR 0xfc400688
#define HWIO_GCC_BLSP1_UART2_APPS_CBCR_ADDR 0xfc400704
#define HWIO_GCC_BLSP1_UART2_SIM_CBCR_ADDR 0xfc400708
#define HWIO_GCC_BLSP1_UART3_APPS_CBCR_ADDR 0xfc400784
#define HWIO_GCC_BLSP1_UART3_SIM_CBCR_ADDR 0xfc400788
#define HWIO_GCC_BLSP1_UART4_APPS_CBCR_ADDR 0xfc400804
#define HWIO_GCC_BLSP1_UART4_SIM_CBCR_ADDR 0xfc400808
#define HWIO_GCC_BLSP1_UART5_APPS_CBCR_ADDR 0xfc400884
#define HWIO_GCC_BLSP1_UART5_SIM_CBCR_ADDR 0xfc400888
#define HWIO_GCC_BLSP1_UART6_APPS_CBCR_ADDR 0xfc400904
#define HWIO_GCC_BLSP1_UART6_SIM_CBCR_ADDR 0xfc400908
#define HWIO_GCC_BLSP2_AHB_CBCR_ADDR 0xfc400944
#define HWIO_GCC_BLSP2_SLEEP_CBCR_ADDR 0xfc400948
#define HWIO_GCC_BLSP2_QUP1_I2C_APPS_CBCR_ADDR 0xfc400988
#define HWIO_GCC_BLSP2_QUP1_SPI_APPS_CBCR_ADDR 0xfc400984
#define HWIO_GCC_BLSP2_QUP2_I2C_APPS_CBCR_ADDR 0xfc400a08
#define HWIO_GCC_BLSP2_QUP2_SPI_APPS_CBCR_ADDR 0xfc400a04
#define HWIO_GCC_BLSP2_QUP3_I2C_APPS_CBCR_ADDR 0xfc400a88
#define HWIO_GCC_BLSP2_QUP3_SPI_APPS_CBCR_ADDR 0xfc400a84
#define HWIO_GCC_BLSP2_QUP4_I2C_APPS_CBCR_ADDR 0xfc400b08
#define HWIO_GCC_BLSP2_QUP4_SPI_APPS_CBCR_ADDR 0xfc400b04
#define HWIO_GCC_BLSP2_QUP5_I2C_APPS_CBCR_ADDR 0xfc400b88
#define HWIO_GCC_BLSP2_QUP5_SPI_APPS_CBCR_ADDR 0xfc400b84
#define HWIO_GCC_BLSP2_QUP6_I2C_APPS_CBCR_ADDR 0xfc400c08
#define HWIO_GCC_BLSP2_QUP6_SPI_APPS_CBCR_ADDR 0xfc400c04
#define HWIO_GCC_BLSP2_UART1_APPS_CBCR_ADDR 0xfc4009c4
#define HWIO_GCC_BLSP2_UART1_SIM_CBCR_ADDR 0xfc4009c8
#define HWIO_GCC_BLSP2_UART2_APPS_CBCR_ADDR 0xfc400a44
#define HWIO_GCC_BLSP2_UART2_SIM_CBCR_ADDR 0xfc400a48
#define HWIO_GCC_BLSP2_UART3_APPS_CBCR_ADDR 0xfc400ac4
#define HWIO_GCC_BLSP2_UART3_SIM_CBCR_ADDR 0xfc400ac8
#define HWIO_GCC_BLSP2_UART4_APPS_CBCR_ADDR 0xfc400b44
#define HWIO_GCC_BLSP2_UART4_SIM_CBCR_ADDR 0xfc400b48
#define HWIO_GCC_BLSP2_UART5_APPS_CBCR_ADDR 0xfc400bc4
#define HWIO_GCC_BLSP2_UART5_SIM_CBCR_ADDR 0xfc400bc8
#define HWIO_GCC_BLSP2_UART6_APPS_CBCR_ADDR 0xfc400c44
#define HWIO_GCC_BLSP2_UART6_SIM_CBCR_ADDR 0xfc400c48
#define HWIO_GCC_BOOT_ROM_AHB_CBCR_ADDR 0xfc400e04
#define HWIO_GCC_CE1_AHB_CBCR_ADDR 0xfc40104c
#define HWIO_GCC_CE1_AXI_CBCR_ADDR 0xfc401048
#define HWIO_GCC_CE1_CBCR_ADDR 0xfc401044
#define HWIO_GCC_CE2_AHB_CBCR_ADDR 0xfc40108c
#define HWIO_GCC_CE2_AXI_CBCR_ADDR 0xfc401088
#define HWIO_GCC_CE2_CBCR_ADDR 0xfc401084
#define HWIO_GCC_CNOC_BUS_TIMEOUT0_AHB_CBCR_ADDR 0xfc4012c4
#define HWIO_GCC_CNOC_BUS_TIMEOUT1_AHB_CBCR_ADDR 0xfc4012cc
#define HWIO_GCC_CNOC_BUS_TIMEOUT2_AHB_CBCR_ADDR 0xfc4012d4
#define HWIO_GCC_CNOC_BUS_TIMEOUT3_AHB_CBCR_ADDR 0xfc4012dc
#define HWIO_GCC_CNOC_BUS_TIMEOUT4_AHB_CBCR_ADDR 0xfc4012e4
#define HWIO_GCC_CNOC_BUS_TIMEOUT5_AHB_CBCR_ADDR 0xfc4012ec
#define HWIO_GCC_CNOC_BUS_TIMEOUT6_AHB_CBCR_ADDR 0xfc4012f4
#define HWIO_GCC_CFG_NOC_AHB_CBCR_ADDR 0xfc400144
#define HWIO_GCC_CFG_NOC_DDR_CFG_CBCR_ADDR 0xfc400148
#define HWIO_GCC_CFG_NOC_RPM_AHB_CBCR_ADDR 0xfc40014c
#define HWIO_GCC_BIMC_DDR_CPLL0_CBCR_ADDR 0xfc401184
#define HWIO_GCC_BIMC_DDR_CPLL1_CBCR_ADDR 0xfc401188
#define HWIO_GCC_DDR_DIM_CFG_CBCR_ADDR 0xfc401180
#define HWIO_GCC_DDR_DIM_SLEEP_CBCR_ADDR 0xfc40118c
#define HWIO_GCC_DEHR_CBCR_ADDR 0xfc401304
#define HWIO_GCC_AHB_CBCR_ADDR 0xfc4010c0
#define HWIO_GCC_IM_SLEEP_CBCR_ADDR 0xfc4010cc
#define HWIO_GCC_XO_CBCR_ADDR 0xfc4010c4
#define HWIO_GCC_XO_DIV4_CBCR_ADDR 0xfc4010c8
#define HWIO_GCC_GP1_CBCR_ADDR 0xfc401900
#define HWIO_GCC_GP2_CBCR_ADDR 0xfc401940
#define HWIO_GCC_GP3_CBCR_ADDR 0xfc401980
#define HWIO_GCC_IMEM_AXI_CBCR_ADDR 0xfc400204
#define HWIO_GCC_IMEM_CFG_AHB_CBCR_ADDR 0xfc400208
#define HWIO_GCC_KPSS_AHB_CBCR_ADDR 0xfc401204
#define HWIO_GCC_KPSS_AXI_CBCR_ADDR 0xfc401208
#define HWIO_GCC_LPASS_Q6_AXI_CBCR_ADDR 0xfc4011c0
#define HWIO_GCC_MMSS_NOC_AT_CBCR_ADDR 0xfc400250
#define HWIO_GCC_MMSS_NOC_CFG_AHB_CBCR_ADDR 0xfc40024c
#define HWIO_GCC_OCMEM_NOC_CFG_AHB_CBCR_ADDR 0xfc400248
#define HWIO_GCC_OCMEM_SYS_NOC_AXI_CBCR_ADDR 0xfc400244
#define HWIO_GCC_MPM_AHB_CBCR_ADDR 0xfc400ec8
#define HWIO_GCC_MSG_RAM_AHB_CBCR_ADDR 0xfc400e44
#define HWIO_GCC_MSS_CFG_AHB_CBCR_ADDR 0xfc400280
#define HWIO_GCC_MSS_Q6_BIMC_AXI_CBCR_ADDR 0xfc400284
#define HWIO_GCC_NOC_CONF_XPU_AHB_CBCR_ADDR 0xfc4001c0
#define HWIO_GCC_PDM2_CBCR_ADDR 0xfc400ccc
#define HWIO_GCC_PDM_AHB_CBCR_ADDR 0xfc400cc4
#define HWIO_GCC_PDM_XO4_CBCR_ADDR 0xfc400cc8
#define HWIO_GCC_PNOC_BUS_TIMEOUT0_AHB_CBCR_ADDR 0xfc401284
#define HWIO_GCC_PNOC_BUS_TIMEOUT1_AHB_CBCR_ADDR 0xfc40128c
#define HWIO_GCC_PNOC_BUS_TIMEOUT2_AHB_CBCR_ADDR 0xfc401294
#define HWIO_GCC_PNOC_BUS_TIMEOUT3_AHB_CBCR_ADDR 0xfc40129c
#define HWIO_GCC_PNOC_BUS_TIMEOUT4_AHB_CBCR_ADDR 0xfc4012a4
#define HWIO_GCC_PRNG_AHB_CBCR_ADDR 0xfc400d04
#define HWIO_GCC_PERIPH_NOC_AHB_CBCR_ADDR 0xfc400184
#define HWIO_GCC_PERIPH_NOC_AT_CBCR_ADDR 0xfc40018c
#define HWIO_GCC_PERIPH_NOC_CFG_AHB_CBCR_ADDR 0xfc400188
#define HWIO_GCC_QDSS_AT_CBCR_ADDR 0xfc40030c
#define HWIO_GCC_QDSS_CFG_AHB_CBCR_ADDR 0xfc400308
#define HWIO_GCC_QDSS_DAP_AHB_CBCR_ADDR 0xfc400304
#define HWIO_GCC_QDSS_DAP_CBCR_ADDR 0xfc400324
#define HWIO_GCC_QDSS_ETR_USB_CBCR_ADDR 0xfc400310
#define HWIO_GCC_QDSS_STM_CBCR_ADDR 0xfc400314
#define HWIO_GCC_QDSS_TRACECLKIN_CBCR_ADDR 0xfc400318
#define HWIO_GCC_QDSS_TSCTR_DIV16_CBCR_ADDR 0xfc400330
#define HWIO_GCC_QDSS_TSCTR_DIV2_CBCR_ADDR 0xfc40031c
#define HWIO_GCC_QDSS_TSCTR_DIV3_CBCR_ADDR 0xfc400320
#define HWIO_GCC_QDSS_TSCTR_DIV4_CBCR_ADDR 0xfc400328
#define HWIO_GCC_QDSS_TSCTR_DIV8_CBCR_ADDR 0xfc40032c
#define HWIO_GCC_QDSS_RBCPR_XPU_AHB_CBCR_ADDR 0xfc4002c0
#define HWIO_GCC_RBCPR_AHB_CBCR_ADDR 0xfc401388
#define HWIO_GCC_RBCPR_CBCR_ADDR 0xfc401384
#define HWIO_GCC_RPM_BUS_AHB_CBCR_ADDR 0xfc400f04
#define HWIO_GCC_RPM_PROC_HCLK_CBCR_ADDR 0xfc400f00
#define HWIO_GCC_RPM_SLEEP_CBCR_ADDR 0xfc400f08
#define HWIO_GCC_RPM_TIMER_CBCR_ADDR 0xfc400f0c
#define HWIO_GCC_SDCC1_AHB_CBCR_ADDR 0xfc4004c8
#define HWIO_GCC_SDCC1_APPS_CBCR_ADDR 0xfc4004c4
#define HWIO_GCC_SDCC1_INACTIVITY_TIMERS_CBCR_ADDR 0xfc4004cc
#define HWIO_GCC_SDCC2_AHB_CBCR_ADDR 0xfc400508
#define HWIO_GCC_SDCC2_APPS_CBCR_ADDR 0xfc400504
#define HWIO_GCC_SDCC2_INACTIVITY_TIMERS_CBCR_ADDR 0xfc40050c
#define HWIO_GCC_SDCC3_AHB_CBCR_ADDR 0xfc400548
#define HWIO_GCC_SDCC3_APPS_CBCR_ADDR 0xfc400544
#define HWIO_GCC_SDCC3_INACTIVITY_TIMERS_CBCR_ADDR 0xfc40054c
#define HWIO_GCC_SDCC4_AHB_CBCR_ADDR 0xfc400588
#define HWIO_GCC_SDCC4_APPS_CBCR_ADDR 0xfc400584
#define HWIO_GCC_SDCC4_INACTIVITY_TIMERS_CBCR_ADDR 0xfc40058c
#define HWIO_GCC_SNOC_BUS_TIMEOUT0_AHB_CBCR_ADDR 0xfc401244
#define HWIO_GCC_SNOC_BUS_TIMEOUT2_AHB_CBCR_ADDR 0xfc40124c
#define HWIO_GCC_SPDM_BIMC_CY_CBCR_ADDR 0xfc401010
#define HWIO_GCC_SPDM_CFG_AHB_CBCR_ADDR 0xfc401004
#define HWIO_GCC_SPDM_DEBUG_CY_CBCR_ADDR 0xfc401018
#define HWIO_GCC_SPDM_FF_CBCR_ADDR 0xfc40100c
#define HWIO_GCC_SPDM_MSTR_AHB_CBCR_ADDR 0xfc401008
#define HWIO_GCC_SPDM_PNOC_CY_CBCR_ADDR 0xfc40101c
#define HWIO_GCC_SPDM_RPM_CY_CBCR_ADDR 0xfc401020
#define HWIO_GCC_SPDM_SNOC_CY_CBCR_ADDR 0xfc401014
#define HWIO_GCC_SPMI_AHB_CBCR_ADDR 0xfc400fcc
#define HWIO_GCC_SPMI_CNOC_AHB_CBCR_ADDR 0xfc400fc8
#define HWIO_GCC_SPMI_SER_CBCR_ADDR 0xfc400fc4
#define HWIO_GCC_SEC_CTRL_ACC_CBCR_ADDR 0xfc400f44
#define HWIO_GCC_SEC_CTRL_AHB_CBCR_ADDR 0xfc400f48
#define HWIO_GCC_SEC_CTRL_BOOT_ROM_PATCH_CBCR_ADDR 0xfc400f54
#define HWIO_GCC_SEC_CTRL_CBCR_ADDR 0xfc400f4c
#define HWIO_GCC_SEC_CTRL_SENSE_CBCR_ADDR 0xfc400f50
#define HWIO_GCC_SNOC_CNOC_AHB_CBCR_ADDR 0xfc400114
#define HWIO_GCC_SNOC_PNOC_AHB_CBCR_ADDR 0xfc400118
#define HWIO_GCC_SYS_NOC_AT_CBCR_ADDR 0xfc40011c
#define HWIO_GCC_SYS_NOC_AXI_CBCR_ADDR 0xfc400104
#define HWIO_GCC_SYS_NOC_KPSS_AHB_CBCR_ADDR 0xfc400110
#define HWIO_GCC_SYS_NOC_QDSS_STM_AXI_CBCR_ADDR 0xfc40010c
#define HWIO_GCC_SYS_NOC_USB3_AXI_CBCR_ADDR 0xfc400108
#define HWIO_GCC_TCSR_AHB_CBCR_ADDR 0xfc400dc4
#define HWIO_GCC_TLMM_AHB_CBCR_ADDR 0xfc400e84
#define HWIO_GCC_TLMM_CBCR_ADDR 0xfc400e88
#define HWIO_GCC_TSIF_AHB_CBCR_ADDR 0xfc400d84
#define HWIO_GCC_TSIF_INACTIVITY_TIMERS_CBCR_ADDR 0xfc400d8c
#define HWIO_GCC_TSIF_REF_CBCR_ADDR 0xfc400d88
#define HWIO_GCC_USB2A_PHY_SLEEP_CBCR_ADDR 0xfc4004ac
#define HWIO_GCC_USB2B_PHY_SLEEP_CBCR_ADDR 0xfc4004b4
#define HWIO_GCC_USB30_MASTER_CBCR_ADDR 0xfc4003c8
#define HWIO_GCC_USB30_MOCK_UTMI_CBCR_ADDR 0xfc4003d0
#define HWIO_GCC_USB30_SLEEP_CBCR_ADDR 0xfc4003cc
#define HWIO_GCC_USB_HS_AHB_CBCR_ADDR 0xfc400488
#define HWIO_GCC_USB_HS_INACTIVITY_TIMERS_CBCR_ADDR 0xfc40048c
#define HWIO_GCC_USB_HS_SYSTEM_CBCR_ADDR 0xfc400484
#define HWIO_GCC_USB_HSIC_AHB_CBCR_ADDR 0xfc400408
#define HWIO_GCC_USB_HSIC_CBCR_ADDR 0xfc400410
#define HWIO_GCC_USB_HSIC_IO_CAL_CBCR_ADDR 0xfc400414
#define HWIO_GCC_USB_HSIC_IO_CAL_SLEEP_CBCR_ADDR 0xfc400418
#define HWIO_GCC_USB_HSIC_SYSTEM_CBCR_ADDR 0xfc40040c
#define HWIO_GCC_PERIPH_NOC_MPU_CFG_AHB_CBCR_ADDR 0xfc401340
#define HWIO_GCC_PERIPH_XPU_AHB_CBCR_ADDR 0xfc400c80
#define HWIO_GCC_DEBUG_CLK_CTL_ADDR 0xfc401880
#define HWIO_LPASS_AUDIO_CORE_AVSYNC_CSR_CBCR_ADDR 0xfe01a000
#define HWIO_LPASS_AUDIO_CORE_CSR_CBCR_ADDR 0xfe01d000
#define HWIO_LPASS_AUDIO_CORE_DML_CBCR_ADDR 0xfe01e000
#define HWIO_LPASS_AUDIO_CORE_IXFABRIC_CBCR_ADDR 0xfe01b000
#define HWIO_LPASS_AUDIO_CORE_IXFABRIC_SPDMTM_CSR_CBCR_ADDR 0xfe028000
#define HWIO_LPASS_AUDIO_CORE_LPAIF_CSR_CBCR_ADDR 0xfe009004
#define HWIO_LPASS_AUDIO_CORE_LPAIF_DMA_CBCR_ADDR 0xfe009000
#define HWIO_LPASS_AUDIO_CORE_LPM_CBCR_ADDR 0xfe019000
#define HWIO_LPASS_AUDIO_CORE_MIDI_LFABIF_CBCR_ADDR 0xfe008018
#define HWIO_LPASS_AUDIO_CORE_RESAMPLER_LFABIF_CBCR_ADDR 0xfe011018
#define HWIO_LPASS_AUDIO_CORE_SECURITY_CBCR_ADDR 0xfe021000
#define HWIO_LPASS_AUDIO_CORE_SLIMBUS_LFABIF_CBCR_ADDR 0xfe012018
#define HWIO_LPASS_AUDIO_CORE_SYSNOC_CBCR_ADDR 0xfe01f000
#define HWIO_LPASS_AUDIO_CORE_TCM_SLAVE_CBCR_ADDR 0xfe01c000
#define HWIO_LPASS_AUDIO_CORE_TIMEOUT_CBCR_ADDR 0xfe020000
#define HWIO_LPASS_AUDIO_WRAPPER_BR_CBCR_ADDR 0xfe024000
#define HWIO_LPASS_AUDIO_WRAPPER_EFABRIC_CBCR_ADDR 0xfe01b004
#define HWIO_LPASS_AUDIO_WRAPPER_EFABRIC_SPDMTM_CSR_CBCR_ADDR 0xfe028004
#define HWIO_LPASS_AUDIO_WRAPPER_LCC_CSR_CBCR_ADDR 0xfe023000
#define HWIO_LPASS_AUDIO_WRAPPER_SECURITY_CBCR_ADDR 0xfe021004
#define HWIO_LPASS_AUDIO_WRAPPER_SMEM_CBCR_ADDR 0xfe025000
#define HWIO_LPASS_AUDIO_WRAPPER_SYSNOC_SWAY_CBCR_ADDR 0xfe01f004
#define HWIO_LPASS_AUDIO_WRAPPER_TIMEOUT_CBCR_ADDR 0xfe020004
#define HWIO_LPASS_Q6SS_AHB_LFABIF_CBCR_ADDR 0xfe022000
#define HWIO_LPASS_Q6SS_AHBM_CBCR_ADDR 0xfe022004
#define HWIO_LPASS_AUDIO_CORE_AVSYNC_BT_XO_CBCR_ADDR 0xfe01a008
#define HWIO_LPASS_AUDIO_CORE_AVSYNC_FM_XO_CBCR_ADDR 0xfe01a00c
#define HWIO_LPASS_AUDIO_CORE_AVSYNC_XO_CBCR_ADDR 0xfe01a004
#define HWIO_LPASS_AUDIO_CORE_GDSC_XO_CBCR_ADDR 0xfe007004
#define HWIO_LPASS_AUDIO_WRAPPER_STM_XO_CBCR_ADDR 0xfe027000
#define HWIO_LPASS_Q6SS_XO_CBCR_ADDR 0xfe026000
#define HWIO_LPASS_AUDIO_CORE_MIDI_CORE_CBCR_ADDR 0xfe008014
#define HWIO_LPASS_AUDIO_CORE_LPAIF_PRI_EBIT_CBCR_ADDR 0xfe00b01c
#define HWIO_LPASS_AUDIO_CORE_LPAIF_PRI_IBIT_CBCR_ADDR 0xfe00b018
#define HWIO_LPASS_AUDIO_CORE_LPAIF_PRI_OSR_CBCR_ADDR 0xfe00b014
#define HWIO_LPASS_AUDIO_CORE_LPAIF_PCM0_EBIT_CBCR_ADDR 0xfe00f018
#define HWIO_LPASS_AUDIO_CORE_LPAIF_PCM0_IBIT_CBCR_ADDR 0xfe00f014
#define HWIO_LPASS_AUDIO_CORE_RESAMPLER_CORE_CBCR_ADDR 0xfe011014
#define HWIO_LPASS_AUDIO_CORE_SLIMBUS_CORE_CBCR_ADDR 0xfe012014
#define HWIO_LPASS_AUDIO_CORE_LPAIF_SEC_EBIT_CBCR_ADDR 0xfe00c01c
#define HWIO_LPASS_AUDIO_CORE_LPAIF_SEC_IBIT_CBCR_ADDR 0xfe00c018
#define HWIO_LPASS_AUDIO_CORE_LPAIF_SEC_OSR_CBCR_ADDR 0xfe00c014
#define HWIO_LPASS_AUDIO_CORE_LPAIF_PCM1_EBIT_CBCR_ADDR 0xfe010018
#define HWIO_LPASS_AUDIO_CORE_LPAIF_PCM1_IBIT_CBCR_ADDR 0xfe010014
#define HWIO_LPASS_AUDIO_CORE_BCR_SLP_CBCR_ADDR 0xfe004004
#define HWIO_LPASS_Q6SS_SLP_CBCR_ADDR 0xfe026004
#define HWIO_LPASS_AUDIO_CORE_LPAIF_CODEC_SPKR_EBIT_CBCR_ADDR 0xfe00a01c
#define HWIO_LPASS_AUDIO_CORE_LPAIF_CODEC_SPKR_IBIT_CBCR_ADDR 0xfe00a018
#define HWIO_LPASS_AUDIO_CORE_LPAIF_CODEC_SPKR_OSR_CBCR_ADDR 0xfe00a014
#define HWIO_LPASS_AUDIO_CORE_LPAIF_TER_EBIT_CBCR_ADDR 0xfe00d01c
#define HWIO_LPASS_AUDIO_CORE_LPAIF_TER_IBIT_CBCR_ADDR 0xfe00d018
#define HWIO_LPASS_AUDIO_CORE_LPAIF_TER_OSR_CBCR_ADDR 0xfe00d014
#define HWIO_LPASS_DBG_CLK_ADDR 0xfe029000
#define HWIO_MSS_BUS_ATB_CBCR_ADDR 0xfc9810b8
#define HWIO_MSS_BUS_BRIDGE_CBCR_ADDR 0xfc98109c
#define HWIO_MSS_BUS_COMBODAC_COMP_CBCR_ADDR 0xfc9810cc
#define HWIO_MSS_BUS_COXM_CBCR_ADDR 0xfc9810bc
#define HWIO_MSS_BUS_CRYPTO_CBCR_ADDR 0xfc9810ac
#define HWIO_MSS_BUS_CSR_CBCR_ADDR 0xfc981098
#define HWIO_MSS_BUS_MODEM_BRIDGE_CX_CBCR_ADDR 0xfc9810c0
#define HWIO_MSS_BUS_MODEM_CX_TO_LS_CBCR_ADDR 0xfc9810a0
#define HWIO_MSS_BUS_NC_HM_BRIDGE_CX_CBCR_ADDR 0xfc9810b4
#define HWIO_MSS_BUS_Q6_CBCR_ADDR 0xfc9810a4
#define HWIO_MSS_BUS_RBCPR_CBCR_ADDR 0xfc9810c8
#define HWIO_MSS_BUS_SLAVE_TIMEOUT_CBCR_ADDR 0xfc9810c4
#define HWIO_MSS_BUS_UIM0_CBCR_ADDR 0xfc981090
#define HWIO_MSS_BUS_UIM1_CBCR_ADDR 0xfc981094
#define HWIO_MSS_MODEM_CFG_AHB_CBCR_ADDR 0xfc9810d4
#define HWIO_MSS_MPLL0_MAIN_MODEM_CX_TO_LS_CBCR_ADDR 0xfc9810e4
#define HWIO_MSS_MPLL1_EARLY_DIV5_CBCR_ADDR 0xfc9810f0
#define HWIO_MSS_MPLL1_OUT_EARLY_DIV5_CBCR_ADDR 0xfc981104
#define HWIO_MSS_BUS_RBCPR_REF_CBCR_ADDR 0xfc9810d0
#define HWIO_MSS_SLEEP_Q6_CBCR_ADDR 0xfc9810fc
#define HWIO_MSS_MODEM_SNOC_AXI_CBCR_ADDR 0xfc9810d8
#define HWIO_MSS_NAV_SNOC_AXI_CBCR_ADDR 0xfc9810dc
#define HWIO_MSS_VMIDMT_SNOC_AXI_CBCR_ADDR 0xfc9810e0
#define HWIO_MSS_UIM0_CBCR_ADDR 0xfc981078
#define HWIO_MSS_XO_UIM0_CBCR_ADDR 0xfc981080
#define HWIO_MSS_UIM1_CBCR_ADDR 0xfc98107c
#define HWIO_MSS_XO_UIM1_CBCR_ADDR 0xfc981084
#define HWIO_MSS_XO_MODEM_CX_TO_LS_CBCR_ADDR 0xfc981088
#define HWIO_MSS_XO_Q6_CBCR_ADDR 0xfc98108c
#define HWIO_MSS_DEBUG_CLOCK_CTL_ADDR 0xfc980078
#define HWIO_MMSS_CAMSS_CCI_CCI_AHB_CBCR_ADDR 0xfd8c3348
#define HWIO_MMSS_CAMSS_CCI_CCI_CBCR_ADDR 0xfd8c3344
#define HWIO_MMSS_CAMSS_CSI0_AHB_CBCR_ADDR 0xfd8c30bc
#define HWIO_MMSS_CAMSS_CSI0_CBCR_ADDR 0xfd8c30b4
#define HWIO_MMSS_CAMSS_CSI0PHY_CBCR_ADDR 0xfd8c30c4
#define HWIO_MMSS_CAMSS_CSI0PIX_CBCR_ADDR 0xfd8c30e4
#define HWIO_MMSS_CAMSS_CSI0RDI_CBCR_ADDR 0xfd8c30d4
#define HWIO_MMSS_CAMSS_CSI1_AHB_CBCR_ADDR 0xfd8c3128
#define HWIO_MMSS_CAMSS_CSI1_CBCR_ADDR 0xfd8c3124
#define HWIO_MMSS_CAMSS_CSI1PHY_CBCR_ADDR 0xfd8c3134
#define HWIO_MMSS_CAMSS_CSI1PIX_CBCR_ADDR 0xfd8c3154
#define HWIO_MMSS_CAMSS_CSI1RDI_CBCR_ADDR 0xfd8c3144
#define HWIO_MMSS_CAMSS_CSI2_AHB_CBCR_ADDR 0xfd8c3188
#define HWIO_MMSS_CAMSS_CSI2_CBCR_ADDR 0xfd8c3184
#define HWIO_MMSS_CAMSS_CSI2PHY_CBCR_ADDR 0xfd8c3194
#define HWIO_MMSS_CAMSS_CSI2PIX_CBCR_ADDR 0xfd8c31b4
#define HWIO_MMSS_CAMSS_CSI2RDI_CBCR_ADDR 0xfd8c31a4
#define HWIO_MMSS_CAMSS_CSI3_AHB_CBCR_ADDR 0xfd8c31e8
#define HWIO_MMSS_CAMSS_CSI3_CBCR_ADDR 0xfd8c31e4
#define HWIO_MMSS_CAMSS_CSI3PHY_CBCR_ADDR 0xfd8c31f4
#define HWIO_MMSS_CAMSS_CSI3PIX_CBCR_ADDR 0xfd8c3214
#define HWIO_MMSS_CAMSS_CSI3RDI_CBCR_ADDR 0xfd8c3204
#define HWIO_MMSS_CAMSS_CSI_VFE0_CBCR_ADDR 0xfd8c3704
#define HWIO_MMSS_CAMSS_CSI_VFE1_CBCR_ADDR 0xfd8c3714
#define HWIO_MMSS_CAMSS_GP0_CBCR_ADDR 0xfd8c3444
#define HWIO_MMSS_CAMSS_GP1_CBCR_ADDR 0xfd8c3474
#define HWIO_MMSS_CAMSS_ISPIF_AHB_CBCR_ADDR 0xfd8c3224
#define HWIO_MMSS_CAMSS_JPEG_JPEG0_CBCR_ADDR 0xfd8c35a8
#define HWIO_MMSS_CAMSS_JPEG_JPEG1_CBCR_ADDR 0xfd8c35ac
#define HWIO_MMSS_CAMSS_JPEG_JPEG2_CBCR_ADDR 0xfd8c35b0
#define HWIO_MMSS_CAMSS_JPEG_JPEG_AHB_CBCR_ADDR 0xfd8c35b4
#define HWIO_MMSS_CAMSS_JPEG_JPEG_AXI_CBCR_ADDR 0xfd8c35b8
#define HWIO_MMSS_CAMSS_JPEG_JPEG_OCMEMNOC_CBCR_ADDR 0xfd8c35bc
#define HWIO_MMSS_CAMSS_MCLK0_CBCR_ADDR 0xfd8c3384
#define HWIO_MMSS_CAMSS_MCLK1_CBCR_ADDR 0xfd8c33b4
#define HWIO_MMSS_CAMSS_MCLK2_CBCR_ADDR 0xfd8c33e4
#define HWIO_MMSS_CAMSS_MCLK3_CBCR_ADDR 0xfd8c3414
#define HWIO_MMSS_CAMSS_MICRO_AHB_CBCR_ADDR 0xfd8c3494
#define HWIO_MMSS_CAMSS_PHY0_CSI0PHYTIMER_CBCR_ADDR 0xfd8c3024
#define HWIO_MMSS_CAMSS_PHY1_CSI1PHYTIMER_CBCR_ADDR 0xfd8c3054
#define HWIO_MMSS_CAMSS_PHY2_CSI2PHYTIMER_CBCR_ADDR 0xfd8c3084
#define HWIO_MMSS_CAMSS_TOP_AHB_CBCR_ADDR 0xfd8c3484
#define HWIO_MMSS_CAMSS_VFE_CPP_AHB_CBCR_ADDR 0xfd8c36b4
#define HWIO_MMSS_CAMSS_VFE_CPP_CBCR_ADDR 0xfd8c36b0
#define HWIO_MMSS_CAMSS_VFE_VFE0_CBCR_ADDR 0xfd8c36a8
#define HWIO_MMSS_CAMSS_VFE_VFE1_CBCR_ADDR 0xfd8c36ac
#define HWIO_MMSS_CAMSS_VFE_VFE_AHB_CBCR_ADDR 0xfd8c36b8
#define HWIO_MMSS_CAMSS_VFE_VFE_AXI_CBCR_ADDR 0xfd8c36bc
#define HWIO_MMSS_CAMSS_VFE_VFE_OCMEMNOC_CBCR_ADDR 0xfd8c36c0
#define HWIO_MMSS_MDSS_AHB_CBCR_ADDR 0xfd8c2308
#define HWIO_MMSS_MDSS_AXI_CBCR_ADDR 0xfd8c2310
#define HWIO_MMSS_MDSS_BYTE0_CBCR_ADDR 0xfd8c233c
#define HWIO_MMSS_MDSS_BYTE1_CBCR_ADDR 0xfd8c2340
#define HWIO_MMSS_MDSS_EDPAUX_CBCR_ADDR 0xfd8c2334
#define HWIO_MMSS_MDSS_EDPLINK_CBCR_ADDR 0xfd8c2330
#define HWIO_MMSS_MDSS_EDPPIXEL_CBCR_ADDR 0xfd8c232c
#define HWIO_MMSS_MDSS_ESC0_CBCR_ADDR 0xfd8c2344
#define HWIO_MMSS_MDSS_ESC1_CBCR_ADDR 0xfd8c2348
#define HWIO_MMSS_MDSS_EXTPCLK_CBCR_ADDR 0xfd8c2324
#define HWIO_MMSS_MDSS_HDMI_AHB_CBCR_ADDR 0xfd8c230c
#define HWIO_MMSS_MDSS_HDMI_CBCR_ADDR 0xfd8c2338
#define HWIO_MMSS_MDSS_MDP_CBCR_ADDR 0xfd8c231c
#define HWIO_MMSS_MDSS_MDP_LUT_CBCR_ADDR 0xfd8c2320
#define HWIO_MMSS_MDSS_PCLK0_CBCR_ADDR 0xfd8c2314
#define HWIO_MMSS_MDSS_PCLK1_CBCR_ADDR 0xfd8c2318
#define HWIO_MMSS_MDSS_VSYNC_CBCR_ADDR 0xfd8c2328
#define HWIO_MMSS_MISC_AHB_CBCR_ADDR 0xfd8c502c
#define HWIO_MMSS_MMSSNOC_AHB_CBCR_ADDR 0xfd8c5024
#define HWIO_MMSS_MMSSNOC_BTO_AHB_CBCR_ADDR 0xfd8c5028
#define HWIO_MMSS_MMSSNOC_AXI_CBCR_ADDR 0xfd8c506c
#define HWIO_MMSS_S0_AXI_CBCR_ADDR 0xfd8c5064
#define HWIO_MMSS_RBCPR_AHB_CBCR_ADDR 0xfd8c4088
#define HWIO_MMSS_RBCPR_CBCR_ADDR 0xfd8c4084
#define HWIO_MMSS_SPDM_AHB_CBCR_ADDR 0xfd8c0230
#define HWIO_MMSS_SPDM_AXI_CBCR_ADDR 0xfd8c0210
#define HWIO_MMSS_SPDM_CSI0_CBCR_ADDR 0xfd8c023c
#define HWIO_MMSS_SPDM_GFX3D_CBCR_ADDR 0xfd8c022c
#define HWIO_MMSS_SPDM_JPEG0_CBCR_ADDR 0xfd8c0204
#define HWIO_MMSS_SPDM_JPEG1_CBCR_ADDR 0xfd8c0208
#define HWIO_MMSS_SPDM_JPEG2_CBCR_ADDR 0xfd8c0224
#define HWIO_MMSS_SPDM_MDP_CBCR_ADDR 0xfd8c020c
#define HWIO_MMSS_SPDM_OCMEMNOC_CBCR_ADDR 0xfd8c0238
#define HWIO_MMSS_SPDM_PCLK0_CBCR_ADDR 0xfd8c0234
#define HWIO_MMSS_SPDM_PCLK1_CBCR_ADDR 0xfd8c0228
#define HWIO_MMSS_SPDM_VCODEC0_CBCR_ADDR 0xfd8c0214
#define HWIO_MMSS_SPDM_VFE0_CBCR_ADDR 0xfd8c0218
#define HWIO_MMSS_SPDM_VFE1_CBCR_ADDR 0xfd8c021c
#define HWIO_MMSS_SPDM_RM_AXI_CBCR_ADDR 0xfd8c0304
#define HWIO_MMSS_SPDM_RM_OCMEMNOC_CBCR_ADDR 0xfd8c0308
#define HWIO_MMSS_OCMEMCX_AHB_CBCR_ADDR 0xfd8c405c
#define HWIO_MMSS_OCMEMCX_OCMEMNOC_CBCR_ADDR 0xfd8c4058
#define HWIO_MMSS_OXILI_OCMEMGX_CBCR_ADDR 0xfd8c402c
#define HWIO_MMSS_OCMEMNOC_CBCR_ADDR 0xfd8c50b4
#define HWIO_MMSS_OXILI_GFX3D_CBCR_ADDR 0xfd8c4028
#define HWIO_MMSS_OXILICX_AHB_CBCR_ADDR 0xfd8c403c
#define HWIO_MMSS_OXILICX_AXI_CBCR_ADDR 0xfd8c4038
#define HWIO_MMSS_VENUS0_AHB_CBCR_ADDR 0xfd8c1030
#define HWIO_MMSS_VENUS0_AXI_CBCR_ADDR 0xfd8c1034
#define HWIO_MMSS_VENUS0_OCMEMNOC_CBCR_ADDR 0xfd8c1038
#define HWIO_MMSS_VENUS0_VCODEC0_CBCR_ADDR 0xfd8c1028
#define HWIO_MMSS_DEBUG_CLK_CTL_ADDR 0xfd8c0900
#define HWIO_WCSS_A_PMU_COMMON_AHB_CBCR_ADDR 0xfb21b034
#define HWIO_WCSS_A_PMU_COMMON_BT_32M_CBCR_ADDR 0xfb21b038
#define HWIO_WCSS_A_PMU_COMMON_BT_FM_19M_CBCR_ADDR 0xfb21b03c
#define HWIO_WCSS_A_PMU_COMMON_CPU_CBCR_ADDR 0xfb21b030
#define HWIO_WCSS_A_PMU_COMMON_PHY_DBG_CBCR_ADDR 0xfb21b028
#define HWIO_WCSS_A_PMU_COMMON_SLP_CBCR_ADDR 0xfb21b040
#define HWIO_WCSS_A_PMU_COMMON_TRC_CBCR_ADDR 0xfb21b02c
#define HWIO_WCSS_A_PMU_COMMON_XO_CBCR_ADDR 0xfb21b044
#define HWIO_WCSS_A_PMU_TOP_AHB_CBCR_ADDR 0xfb21b008
#define HWIO_WCSS_A_PMU_TOP_SLP_CBCR_ADDR 0xfb21b010
#define HWIO_WCSS_A_PMU_TOP_XO_CBCR_ADDR 0xfb21b014
#define HWIO_WCSS_A_PMU_DAC_SM_CBCR_ADDR 0xfb21b084
#define HWIO_WCSS_A_PMU_WLAN_AHB_CBCR_ADDR 0xfb21b074
#define HWIO_WCSS_A_PMU_WLAN_PHY_DAC_CBCR_ADDR 0xfb21b070
#define HWIO_WCSS_A_PMU_WLAN_PHY_DBG_CBCR_ADDR 0xfb21b06c
#define HWIO_WCSS_A_PMU_WLAN_PHY_MAIN1_FAST_CBCR_ADDR 0xfb21b05c
#define HWIO_WCSS_A_PMU_WLAN_RFA_CAL_CBCR_ADDR 0xfb21b058
#define HWIO_WCSS_A_PMU_WLAN_RFIF_CBCR_ADDR 0xfb21b07c
#define HWIO_WCSS_A_PMU_WLAN_PHY_MAIN1_RX_CBCR_ADDR 0xfb21b064
#define HWIO_WCSS_A_PMU_WLAN_PHY_MAIN1_TX_CBCR_ADDR 0xfb21b060
#define HWIO_WCSS_A_PMU_WLAN_PHY_MAIN2_CBCR_ADDR 0xfb21b068
#define HWIO_WCSS_A_PMU_WCSS_DEBUG_CLK_CTL_ADDR 0xfb21b1e0
#define HWIO_APCS_GLB_CLK_DIAG_ADDR 0xf901101c
#define HWIO_GCC_XO_DIV4_CBCR_ADDR 0xfc4010c8
#define HWIO_GCC_CLOCK_FRQ_MEASURE_CTL_ADDR 0xfc401884
#define HWIO_GCC_CLOCK_FRQ_MEASURE_STATUS_ADDR 0xfc401888
#define HWIO_TLMM_GPIO_CFG0_ADDR 0xfd511000
#define HWIO_MODEM_CLK_DBG_CFG_ADDR 0xfcb20030
#define HWIO_MSS_NAV_CLK_CTL_ADDR 0xfcaf8008
#define HWIO_MSS_QDSP6SS_TEST_CLK_CTL_ADDR 0xfc882010
#define HWIO_GCC_PLLTEST_PAD_CFG_ADDR 0xfc40188c

//Sub-system Test Masks
#define CLK_GCC_TEST (0x1<<0xC)
#define CLK_LPASS_TEST (0x2<<0xC)
#define CLK_MSS_TEST (0x3<<0xC)
#define CLK_MMSS_TEST (0x4<<0xC)
#define CLK_WCSS_TEST (0x5<<0xC)
#define CLK_APCS_TEST (0x6<<0xC)
#define CLK_MSS_SUB_MUX_MODEM (0x1<<0x1C)
#define CLK_MSS_SUB_MUX_NAV (0x2<<0x1C)
#define CLK_MSS_SUB_MUX_Q6 (0x3<<0x1C)
//Clock Test
// GCC Test Clocks
#define CLK_TEST_GCC_BAM_DMA_AHB_CLK ( CLK_GCC_TEST|0x0E0)
#define CLK_TEST_GCC_BAM_DMA_INACTIVITY_TIMERS_CLK ( CLK_GCC_TEST|0x0E1)
#define CLK_TEST_GCC_BIMC_CFG_AHB_CLK ( CLK_GCC_TEST|0x151)
#define CLK_TEST_GCC_BIMC_CLK ( CLK_GCC_TEST|0x154)
#define CLK_TEST_GCC_BIMC_KPSS_AXI_CLK ( CLK_GCC_TEST|0x155)
#define CLK_TEST_GCC_BIMC_SLEEP_CLK ( CLK_GCC_TEST|0x152)
#define CLK_TEST_GCC_BIMC_SYSNOC_AXI_CLK ( CLK_GCC_TEST|0x153)
#define CLK_TEST_GCC_BIMC_XO_CLK ( CLK_GCC_TEST|0x150)
#define CLK_TEST_GCC_BLSP1_AHB_CLK ( CLK_GCC_TEST|0x088)
#define CLK_TEST_GCC_BLSP1_SLEEP_CLK ( CLK_GCC_TEST|0x089)
#define CLK_TEST_GCC_BLSP1_QUP1_I2C_APPS_CLK ( CLK_GCC_TEST|0x08B)
#define CLK_TEST_GCC_BLSP1_QUP1_SPI_APPS_CLK ( CLK_GCC_TEST|0x08A)
#define CLK_TEST_GCC_BLSP1_QUP2_I2C_APPS_CLK ( CLK_GCC_TEST|0x090)
#define CLK_TEST_GCC_BLSP1_QUP2_SPI_APPS_CLK ( CLK_GCC_TEST|0x08E)
#define CLK_TEST_GCC_BLSP1_QUP3_I2C_APPS_CLK ( CLK_GCC_TEST|0x094)
#define CLK_TEST_GCC_BLSP1_QUP3_SPI_APPS_CLK ( CLK_GCC_TEST|0x093)
#define CLK_TEST_GCC_BLSP1_QUP4_I2C_APPS_CLK ( CLK_GCC_TEST|0x099)
#define CLK_TEST_GCC_BLSP1_QUP4_SPI_APPS_CLK ( CLK_GCC_TEST|0x098)
#define CLK_TEST_GCC_BLSP1_QUP5_I2C_APPS_CLK ( CLK_GCC_TEST|0x09D)
#define CLK_TEST_GCC_BLSP1_QUP5_SPI_APPS_CLK ( CLK_GCC_TEST|0x09C)
#define CLK_TEST_GCC_BLSP1_QUP6_I2C_APPS_CLK ( CLK_GCC_TEST|0x0A2)
#define CLK_TEST_GCC_BLSP1_QUP6_SPI_APPS_CLK ( CLK_GCC_TEST|0x0A1)
#define CLK_TEST_GCC_BLSP1_UART1_APPS_CLK ( CLK_GCC_TEST|0x08C)
#define CLK_TEST_GCC_BLSP1_UART1_SIM_CLK ( CLK_GCC_TEST|0x08D)
#define CLK_TEST_GCC_BLSP1_UART2_APPS_CLK ( CLK_GCC_TEST|0x091)
#define CLK_TEST_GCC_BLSP1_UART2_SIM_CLK ( CLK_GCC_TEST|0x092)
#define CLK_TEST_GCC_BLSP1_UART3_APPS_CLK ( CLK_GCC_TEST|0x095)
#define CLK_TEST_GCC_BLSP1_UART3_SIM_CLK ( CLK_GCC_TEST|0x096)
#define CLK_TEST_GCC_BLSP1_UART4_APPS_CLK ( CLK_GCC_TEST|0x09A)
#define CLK_TEST_GCC_BLSP1_UART4_SIM_CLK ( CLK_GCC_TEST|0x09B)
#define CLK_TEST_GCC_BLSP1_UART5_APPS_CLK ( CLK_GCC_TEST|0x09E)
#define CLK_TEST_GCC_BLSP1_UART5_SIM_CLK ( CLK_GCC_TEST|0x0A0)
#define CLK_TEST_GCC_BLSP1_UART6_APPS_CLK ( CLK_GCC_TEST|0x0A3)
#define CLK_TEST_GCC_BLSP1_UART6_SIM_CLK ( CLK_GCC_TEST|0x0A4)
#define CLK_TEST_GCC_BLSP2_AHB_CLK ( CLK_GCC_TEST|0x0A8)
#define CLK_TEST_GCC_BLSP2_SLEEP_CLK ( CLK_GCC_TEST|0x0A9)
#define CLK_TEST_GCC_BLSP2_QUP1_I2C_APPS_CLK ( CLK_GCC_TEST|0x0AB)
#define CLK_TEST_GCC_BLSP2_QUP1_SPI_APPS_CLK ( CLK_GCC_TEST|0x0AA)
#define CLK_TEST_GCC_BLSP2_QUP2_I2C_APPS_CLK ( CLK_GCC_TEST|0x0B0)
#define CLK_TEST_GCC_BLSP2_QUP2_SPI_APPS_CLK ( CLK_GCC_TEST|0x0AE)
#define CLK_TEST_GCC_BLSP2_QUP3_I2C_APPS_CLK ( CLK_GCC_TEST|0x0B4)
#define CLK_TEST_GCC_BLSP2_QUP3_SPI_APPS_CLK ( CLK_GCC_TEST|0x0B3)
#define CLK_TEST_GCC_BLSP2_QUP4_I2C_APPS_CLK ( CLK_GCC_TEST|0x0B9)
#define CLK_TEST_GCC_BLSP2_QUP4_SPI_APPS_CLK ( CLK_GCC_TEST|0x0B8)
#define CLK_TEST_GCC_BLSP2_QUP5_I2C_APPS_CLK ( CLK_GCC_TEST|0x0BD)
#define CLK_TEST_GCC_BLSP2_QUP5_SPI_APPS_CLK ( CLK_GCC_TEST|0x0BC)
#define CLK_TEST_GCC_BLSP2_QUP6_I2C_APPS_CLK ( CLK_GCC_TEST|0x0C2)
#define CLK_TEST_GCC_BLSP2_QUP6_SPI_APPS_CLK ( CLK_GCC_TEST|0x0C1)
#define CLK_TEST_GCC_BLSP2_UART1_APPS_CLK ( CLK_GCC_TEST|0x0AC)
#define CLK_TEST_GCC_BLSP2_UART1_SIM_CLK ( CLK_GCC_TEST|0x0AD)
#define CLK_TEST_GCC_BLSP2_UART2_APPS_CLK ( CLK_GCC_TEST|0x0B1)
#define CLK_TEST_GCC_BLSP2_UART2_SIM_CLK ( CLK_GCC_TEST|0x0B2)
#define CLK_TEST_GCC_BLSP2_UART3_APPS_CLK ( CLK_GCC_TEST|0x0B5)
#define CLK_TEST_GCC_BLSP2_UART3_SIM_CLK ( CLK_GCC_TEST|0x0B6)
#define CLK_TEST_GCC_BLSP2_UART4_APPS_CLK ( CLK_GCC_TEST|0x0BA)
#define CLK_TEST_GCC_BLSP2_UART4_SIM_CLK ( CLK_GCC_TEST|0x0BB)
#define CLK_TEST_GCC_BLSP2_UART5_APPS_CLK ( CLK_GCC_TEST|0x0BE)
#define CLK_TEST_GCC_BLSP2_UART5_SIM_CLK ( CLK_GCC_TEST|0x0C0)
#define CLK_TEST_GCC_BLSP2_UART6_APPS_CLK ( CLK_GCC_TEST|0x0C3)
#define CLK_TEST_GCC_BLSP2_UART6_SIM_CLK ( CLK_GCC_TEST|0x0C4)
#define CLK_TEST_GCC_BOOT_ROM_AHB_CLK ( CLK_GCC_TEST|0x0F8)
#define CLK_TEST_GCC_CE1_AHB_CLK ( CLK_GCC_TEST|0x13A)
#define CLK_TEST_GCC_CE1_AXI_CLK ( CLK_GCC_TEST|0x139)
#define CLK_TEST_GCC_CE1_CLK ( CLK_GCC_TEST|0x138)
#define CLK_TEST_GCC_CE2_AHB_CLK ( CLK_GCC_TEST|0x142)
#define CLK_TEST_GCC_CE2_AXI_CLK ( CLK_GCC_TEST|0x141)
#define CLK_TEST_GCC_CE2_CLK ( CLK_GCC_TEST|0x140)
#define CLK_TEST_GCC_CNOC_BUS_TIMEOUT0_AHB_CLK ( CLK_GCC_TEST|0x180)
#define CLK_TEST_GCC_CNOC_BUS_TIMEOUT1_AHB_CLK ( CLK_GCC_TEST|0x181)
#define CLK_TEST_GCC_CNOC_BUS_TIMEOUT2_AHB_CLK ( CLK_GCC_TEST|0x182)
#define CLK_TEST_GCC_CNOC_BUS_TIMEOUT3_AHB_CLK ( CLK_GCC_TEST|0x183)
#define CLK_TEST_GCC_CNOC_BUS_TIMEOUT4_AHB_CLK ( CLK_GCC_TEST|0x184)
#define CLK_TEST_GCC_CNOC_BUS_TIMEOUT5_AHB_CLK ( CLK_GCC_TEST|0x185)
#define CLK_TEST_GCC_CNOC_BUS_TIMEOUT6_AHB_CLK ( CLK_GCC_TEST|0x186)
#define CLK_TEST_GCC_CFG_NOC_AHB_CLK ( CLK_GCC_TEST|0x008)
#define CLK_TEST_GCC_CFG_NOC_DDR_CFG_CLK ( CLK_GCC_TEST|0x009)
#define CLK_TEST_GCC_CFG_NOC_RPM_AHB_CLK ( CLK_GCC_TEST|0x00A)
#define CLK_TEST_GCC_CFG_NOC_TIC_CLK ( CLK_GCC_TEST|0x00B)
#define CLK_TEST_GCC_BIMC_DDR_CPLL0_CLK ( CLK_GCC_TEST|0x159)
#define CLK_TEST_GCC_BIMC_DDR_CPLL1_CLK ( CLK_GCC_TEST|0x15A)
#define CLK_TEST_GCC_DDR_DIM_CFG_CLK ( CLK_GCC_TEST|0x158)
#define CLK_TEST_GCC_DDR_DIM_SLEEP_CLK ( CLK_GCC_TEST|0x15B)
#define CLK_TEST_GCC_DEHR_CLK ( CLK_GCC_TEST|0x188)
#define CLK_TEST_GCC_AHB_CLK ( CLK_GCC_TEST|0x148)
#define CLK_TEST_GCC_IM_SLEEP_CLK ( CLK_GCC_TEST|0x14B)
#define CLK_TEST_GCC_XO_CLK ( CLK_GCC_TEST|0x149)
#define CLK_TEST_GCC_XO_DIV4_CLK ( CLK_GCC_TEST|0x14A)
#define CLK_TEST_GCC_IMEM_AXI_CLK ( CLK_GCC_TEST|0x020)
#define CLK_TEST_GCC_IMEM_CFG_AHB_CLK ( CLK_GCC_TEST|0x021)
#define CLK_TEST_GCC_KPSS_AHB_CLK ( CLK_GCC_TEST|0x168)
#define CLK_TEST_GCC_KPSS_AXI_CLK ( CLK_GCC_TEST|0x169)
#define CLK_TEST_KPSS_GCC_DBG_CLK ( CLK_GCC_TEST|0x16A)
#define CLK_TEST_GCC_LPASS_Q6_AXI_CLK ( CLK_GCC_TEST|0x160)
#define CLK_TEST_LPASS_GCC_DBG_CLK ( CLK_GCC_TEST|0x161)
#define CLK_TEST_GCC_MMSS_NOC_AT_CLK ( CLK_GCC_TEST|0x02B)
#define CLK_TEST_GCC_MMSS_NOC_CFG_AHB_CLK ( CLK_GCC_TEST|0x02A)
#define CLK_TEST_GCC_OCMEM_NOC_CFG_AHB_CLK ( CLK_GCC_TEST|0x029)
#define CLK_TEST_GCC_OCMEM_SYS_NOC_AXI_CLK_D ( CLK_GCC_TEST|0x028) //Dumplicate so add D
#define CLK_TEST_MMSS_GCC_DBG_CLK ( CLK_GCC_TEST|0x02C)
#define CLK_TEST_GCC_MPM_AHB_CLK ( CLK_GCC_TEST|0x110)
#define CLK_TEST_GCC_MSG_RAM_AHB_CLK ( CLK_GCC_TEST|0x100)
#define CLK_TEST_GCC_MSS_CFG_AHB_CLK ( CLK_GCC_TEST|0x030)
#define CLK_TEST_GCC_MSS_Q6_BIMC_AXI_CLK ( CLK_GCC_TEST|0x031)
#define CLK_TEST_MSS_GCC_DBG_CLK ( CLK_GCC_TEST|0x032)
#define CLK_TEST_GCC_NOC_CONF_XPU_AHB_CLK ( CLK_GCC_TEST|0x018)
#define CLK_TEST_GPLL0_DTEST ( CLK_GCC_TEST|0x1C0)
#define CLK_TEST_GPLL0_LOCK_DET ( CLK_GCC_TEST|0x1C1)
#define CLK_TEST_GPLL1_DTEST ( CLK_GCC_TEST|0x1C2)
#define CLK_TEST_GPLL1_LOCK_DET ( CLK_GCC_TEST|0x1C3)
#define CLK_TEST_GPLL2_DTEST ( CLK_GCC_TEST|0x1C4)
#define CLK_TEST_GPLL2_LOCK_DET ( CLK_GCC_TEST|0x1C5)
#define CLK_TEST_GPLL3_DTEST ( CLK_GCC_TEST|0x1C6)
#define CLK_TEST_GPLL3_LOCK_DET ( CLK_GCC_TEST|0x1C7)
#define CLK_TEST_KPSS_GCC_RINGOSC_CLK ( CLK_GCC_TEST|0x1D0)
#define CLK_TEST_MPM_GCC_TEMP_SENSOR_RINGOSC_CLK ( CLK_GCC_TEST|0x1C8)
#define CLK_TEST_USB2_PHY_GCC_ATEST_ULPI_0_CLK ( CLK_GCC_TEST|0x1A0)
#define CLK_TEST_USB2_PHY_GCC_ATEST_ULPI_1_CLK ( CLK_GCC_TEST|0x1A8)
#define CLK_TEST_USB2_PHY_WRAPPER_GCC_USB30_UTMI_CLK ( CLK_GCC_TEST|0x1B8)
#define CLK_TEST_USB3_PHY_WRAPPER_GCC_USB3_PIPE_CLK ( CLK_GCC_TEST|0x1B0)
#define CLK_TEST_WCSS_GCC_DBG_CLK ( CLK_GCC_TEST|0x198)
#define CLK_TEST_GCC_PDM2_CLK ( CLK_GCC_TEST|0x0D2)
#define CLK_TEST_GCC_PDM_AHB_CLK ( CLK_GCC_TEST|0x0D0)
#define CLK_TEST_GCC_PDM_XO4_CLK ( CLK_GCC_TEST|0x0D1)
#define CLK_TEST_GCC_PNOC_BUS_TIMEOUT0_AHB_CLK ( CLK_GCC_TEST|0x178)
#define CLK_TEST_GCC_PNOC_BUS_TIMEOUT1_AHB_CLK ( CLK_GCC_TEST|0x179)
#define CLK_TEST_GCC_PNOC_BUS_TIMEOUT2_AHB_CLK ( CLK_GCC_TEST|0x17A)
#define CLK_TEST_GCC_PNOC_BUS_TIMEOUT3_AHB_CLK ( CLK_GCC_TEST|0x17B)
#define CLK_TEST_GCC_PNOC_BUS_TIMEOUT4_AHB_CLK ( CLK_GCC_TEST|0x17C)
#define CLK_TEST_GCC_PRNG_AHB_CLK ( CLK_GCC_TEST|0x0D8)
#define CLK_TEST_GCC_PERIPH_NOC_AHB_CLK ( CLK_GCC_TEST|0x010)
#define CLK_TEST_GCC_PERIPH_NOC_AT_CLK ( CLK_GCC_TEST|0x012)
#define CLK_TEST_GCC_PERIPH_NOC_CFG_AHB_CLK ( CLK_GCC_TEST|0x011)
#define CLK_TEST_GCC_QDSS_AT_CLK ( CLK_GCC_TEST|0x042)
#define CLK_TEST_GCC_QDSS_CFG_AHB_CLK ( CLK_GCC_TEST|0x041)
#define CLK_TEST_GCC_QDSS_DAP_AHB_CLK ( CLK_GCC_TEST|0x040)
#define CLK_TEST_GCC_QDSS_DAP_CLK ( CLK_GCC_TEST|0x049)
#define CLK_TEST_GCC_QDSS_ETR_USB_CLK ( CLK_GCC_TEST|0x043)
#define CLK_TEST_GCC_QDSS_STM_CLK ( CLK_GCC_TEST|0x044)
#define CLK_TEST_GCC_QDSS_TRACECLKIN_CLK ( CLK_GCC_TEST|0x045)
#define CLK_TEST_GCC_QDSS_TSCTR_DIV16_CLK ( CLK_GCC_TEST|0x04C)
#define CLK_TEST_GCC_QDSS_TSCTR_DIV2_CLK ( CLK_GCC_TEST|0x046)
#define CLK_TEST_GCC_QDSS_TSCTR_DIV3_CLK ( CLK_GCC_TEST|0x048)
#define CLK_TEST_GCC_QDSS_TSCTR_DIV4_CLK ( CLK_GCC_TEST|0x04A)
#define CLK_TEST_GCC_QDSS_TSCTR_DIV8_CLK ( CLK_GCC_TEST|0x04B)
#define CLK_TEST_GCC_QDSS_RBCPR_XPU_AHB_CLK ( CLK_GCC_TEST|0x038)
#define CLK_TEST_GCC_RBCPR_AHB_CLK ( CLK_GCC_TEST|0x191)
#define CLK_TEST_GCC_RBCPR_CLK ( CLK_GCC_TEST|0x190)
#define CLK_TEST_GCC_RPM_BUS_AHB_CLK ( CLK_GCC_TEST|0x11A)
#define CLK_TEST_GCC_RPM_PROC_FCLK ( CLK_GCC_TEST|0x118)
#define CLK_TEST_GCC_RPM_PROC_HCLK ( CLK_GCC_TEST|0x119)
#define CLK_TEST_GCC_RPM_SLEEP_CLK ( CLK_GCC_TEST|0x11B)
#define CLK_TEST_GCC_RPM_TIMER_CLK ( CLK_GCC_TEST|0x11C)
#define CLK_TEST_GCC_SDCC1_AHB_CLK ( CLK_GCC_TEST|0x069)
#define CLK_TEST_GCC_SDCC1_APPS_CLK ( CLK_GCC_TEST|0x068)
#define CLK_TEST_GCC_SDCC1_INACTIVITY_TIMERS_CLK ( CLK_GCC_TEST|0x06A)
#define CLK_TEST_GCC_SDCC2_AHB_CLK ( CLK_GCC_TEST|0x071)
#define CLK_TEST_GCC_SDCC2_APPS_CLK ( CLK_GCC_TEST|0x070)
#define CLK_TEST_GCC_SDCC2_INACTIVITY_TIMERS_CLK ( CLK_GCC_TEST|0x072)
#define CLK_TEST_GCC_SDCC3_AHB_CLK ( CLK_GCC_TEST|0x079)
#define CLK_TEST_GCC_SDCC3_APPS_CLK ( CLK_GCC_TEST|0x078)
#define CLK_TEST_GCC_SDCC3_INACTIVITY_TIMERS_CLK ( CLK_GCC_TEST|0x07A)
#define CLK_TEST_GCC_SDCC4_AHB_CLK ( CLK_GCC_TEST|0x081)
#define CLK_TEST_GCC_SDCC4_APPS_CLK ( CLK_GCC_TEST|0x080)
#define CLK_TEST_GCC_SDCC4_INACTIVITY_TIMERS_CLK ( CLK_GCC_TEST|0x082)
#define CLK_TEST_GCC_SNOC_BUS_TIMEOUT0_AHB_CLK ( CLK_GCC_TEST|0x170)
#define CLK_TEST_GCC_SNOC_BUS_TIMEOUT2_AHB_CLK ( CLK_GCC_TEST|0x171)
#define CLK_TEST_GCC_SPDM_BIMC_CY_CLK ( CLK_GCC_TEST|0x133)
#define CLK_TEST_GCC_SPDM_CFG_AHB_CLK ( CLK_GCC_TEST|0x130)
#define CLK_TEST_GCC_SPDM_FF_CLK ( CLK_GCC_TEST|0x132)
#define CLK_TEST_GCC_SPDM_MSTR_AHB_CLK ( CLK_GCC_TEST|0x131)
#define CLK_TEST_GCC_SPDM_PNOC_CY_CLK ( CLK_GCC_TEST|0x135)
#define CLK_TEST_GCC_SPDM_RPM_CY_CLK ( CLK_GCC_TEST|0x136)
#define CLK_TEST_GCC_SPDM_SNOC_CY_CLK ( CLK_GCC_TEST|0x134)
#define CLK_TEST_GCC_SPMI_AHB_CLK ( CLK_GCC_TEST|0x12A)
#define CLK_TEST_GCC_SPMI_CNOC_AHB_CLK ( CLK_GCC_TEST|0x129)
#define CLK_TEST_GCC_SPMI_SER_CLK ( CLK_GCC_TEST|0x128)
#define CLK_TEST_GCC_SEC_CTRL_ACC_CLK ( CLK_GCC_TEST|0x120)
#define CLK_TEST_GCC_SEC_CTRL_AHB_CLK ( CLK_GCC_TEST|0x121)
#define CLK_TEST_GCC_SEC_CTRL_BOOT_ROM_PATCH_CLK ( CLK_GCC_TEST|0x124)
#define CLK_TEST_GCC_SEC_CTRL_CLK ( CLK_GCC_TEST|0x122)
#define CLK_TEST_GCC_SEC_CTRL_SENSE_CLK ( CLK_GCC_TEST|0x123)
#define CLK_TEST_GCC_SNOC_CNOC_AHB_CLK ( CLK_GCC_TEST|0x004)
#define CLK_TEST_GCC_SNOC_PNOC_AHB_CLK ( CLK_GCC_TEST|0x005)
#define CLK_TEST_GCC_SYS_NOC_AT_CLK ( CLK_GCC_TEST|0x006)
#define CLK_TEST_GCC_SYS_NOC_AXI_CLK ( CLK_GCC_TEST|0x000)
#define CLK_TEST_GCC_SYS_NOC_KPSS_AHB_CLK ( CLK_GCC_TEST|0x003)
#define CLK_TEST_GCC_SYS_NOC_QDSS_STM_AXI_CLK ( CLK_GCC_TEST|0x002)
#define CLK_TEST_GCC_SYS_NOC_USB3_AXI_CLK ( CLK_GCC_TEST|0x001)
#define CLK_TEST_GCC_TCSR_AHB_CLK ( CLK_GCC_TEST|0x0F0)
#define CLK_TEST_GCC_TLMM_AHB_CLK ( CLK_GCC_TEST|0x108)
#define CLK_TEST_GCC_TLMM_CLK ( CLK_GCC_TEST|0x109)
#define CLK_TEST_GCC_TSIF_AHB_CLK ( CLK_GCC_TEST|0x0E8)
#define CLK_TEST_GCC_TSIF_INACTIVITY_TIMERS_CLK ( CLK_GCC_TEST|0x0EA)
#define CLK_TEST_GCC_TSIF_REF_CLK ( CLK_GCC_TEST|0x0E9)
#define CLK_TEST_GCC_USB2A_PHY_SLEEP_CLK ( CLK_GCC_TEST|0x063)
#define CLK_TEST_GCC_USB2B_PHY_SLEEP_CLK ( CLK_GCC_TEST|0x064)
#define CLK_TEST_GCC_USB30_MASTER_CLK ( CLK_GCC_TEST|0x050)
#define CLK_TEST_GCC_USB30_MOCK_UTMI_CLK ( CLK_GCC_TEST|0x052)
#define CLK_TEST_GCC_USB30_SLEEP_CLK ( CLK_GCC_TEST|0x051)
#define CLK_TEST_GCC_USB_HS_AHB_CLK ( CLK_GCC_TEST|0x061)
#define CLK_TEST_GCC_USB_HS_INACTIVITY_TIMERS_CLK ( CLK_GCC_TEST|0x062)
#define CLK_TEST_GCC_USB_HS_SYSTEM_CLK ( CLK_GCC_TEST|0x060)
#define CLK_TEST_GCC_USB_HSIC_AHB_CLK ( CLK_GCC_TEST|0x058)
#define CLK_TEST_GCC_USB_HSIC_CLK ( CLK_GCC_TEST|0x05A)
#define CLK_TEST_GCC_USB_HSIC_IO_CAL_CLK ( CLK_GCC_TEST|0x05B)
#define CLK_TEST_GCC_USB_HSIC_IO_CAL_SLEEP_CLK ( CLK_GCC_TEST|0x05C)
#define CLK_TEST_GCC_USB_HSIC_SYSTEM_CLK ( CLK_GCC_TEST|0x059)
#define CLK_TEST_GCC_PERIPH_NOC_MPU_CFG_AHB_CLK ( CLK_GCC_TEST|0x0C9)
#define CLK_TEST_GCC_PERIPH_XPU_AHB_CLK ( CLK_GCC_TEST|0x0C8)
// LPASS Test Clocks
#define CLK_TEST_AHBFABRIC_CLK_SRC ( CLK_LPASS_TEST|0x1A)
#define CLK_TEST_AUDIO_CORE_AVSYNC_CSR_CLK ( CLK_LPASS_TEST|0x2F)
#define CLK_TEST_AUDIO_CORE_CSR_CLK ( CLK_LPASS_TEST|0x42)
#define CLK_TEST_AUDIO_CORE_DML_CLK ( CLK_LPASS_TEST|0x58)
#define CLK_TEST_AUDIO_CORE_IXFABRIC_CLK ( CLK_LPASS_TEST|0x59)
#define CLK_TEST_AUDIO_CORE_IXFABRIC_SPDMTM_CSR_CLK ( CLK_LPASS_TEST|0x41)
#define CLK_TEST_AUDIO_CORE_LPAIF_CSR_CLK ( CLK_LPASS_TEST|0x37)
#define CLK_TEST_AUDIO_CORE_LPAIF_DMA_CLK ( CLK_LPASS_TEST|0x38)
#define CLK_TEST_AUDIO_CORE_LPM_CLK ( CLK_LPASS_TEST|0x47)
#define CLK_TEST_AUDIO_CORE_MIDI_LFABIF_CLK ( CLK_LPASS_TEST|0x40)
#define CLK_TEST_AUDIO_CORE_RESAMPLER_LFABIF_CLK ( CLK_LPASS_TEST|0x3C)
#define CLK_TEST_AUDIO_CORE_SECURITY_CLK ( CLK_LPASS_TEST|0x3A)
#define CLK_TEST_AUDIO_CORE_SLIMBUS_LFABIF_CLK ( CLK_LPASS_TEST|0x3E)
#define CLK_TEST_AUDIO_CORE_SYSNOC_CLK ( CLK_LPASS_TEST|0x1F)
#define CLK_TEST_AUDIO_CORE_TIMEOUT_CLK ( CLK_LPASS_TEST|0x39)
#define CLK_TEST_AUDIO_WRAPPER_BR_CLK ( CLK_LPASS_TEST|0x22)
#define CLK_TEST_AUDIO_WRAPPER_EFABRIC_CLK ( CLK_LPASS_TEST|0x25)
#define CLK_TEST_AUDIO_WRAPPER_EFABRIC_SPDMTM_CSR_CLK ( CLK_LPASS_TEST|0x24)
#define CLK_TEST_AUDIO_WRAPPER_LCC_CSR_CLK ( CLK_LPASS_TEST|0x27)
#define CLK_TEST_AUDIO_WRAPPER_SECURITY_CLK ( CLK_LPASS_TEST|0x26)
#define CLK_TEST_AUDIO_WRAPPER_SMEM_CLK ( CLK_LPASS_TEST|0x21)
#define CLK_TEST_AUDIO_WRAPPER_TIMEOUT_CLK ( CLK_LPASS_TEST|0x20)
#define CLK_TEST_Q6SS_AHB_LFABIF_CLK ( CLK_LPASS_TEST|0x1E)
#define CLK_TEST_Q6SS_AHBM_CLK ( CLK_LPASS_TEST|0x1D)
#define CLK_TEST_AUDIO_CORE_AVSYNC_BT_XO_CLK ( CLK_LPASS_TEST|0x2D)
#define CLK_TEST_AUDIO_CORE_AVSYNC_FM_XO_CLK ( CLK_LPASS_TEST|0x2C)
#define CLK_TEST_AUDIO_CORE_AVSYNC_XO_CLK ( CLK_LPASS_TEST|0x2E)
#define CLK_TEST_AUDIO_CORE_GDSC_XO_CLK ( CLK_LPASS_TEST|0x28)
#define CLK_TEST_CXO_CLK_SRC ( CLK_LPASS_TEST|0xE)
#define CLK_TEST_Q6SS_XO_CLK ( CLK_LPASS_TEST|0x2B)
#define CLK_TEST_AUDIO_CORE_MIDI_CORE_CLK ( CLK_LPASS_TEST|0x3F)
#define CLK_TEST_MIDI_CLK_SRC ( CLK_LPASS_TEST|0x19)
#define CLK_TEST_LPAIF_PCMOE_CLK ( CLK_LPASS_TEST|0x30)
#define CLK_TEST_PAIF_PCMOE_CLK_SRC ( CLK_LPASS_TEST|0xF)
#define CLK_TEST_LPAIF_PRI_CLK_SRC ( CLK_LPASS_TEST|0x17)
#define CLK_TEST_LPAIF_PCM0_CLK_SRC ( CLK_LPASS_TEST|0x13)
#define CLK_TEST_Q6CORE_CLK_SRC ( CLK_LPASS_TEST|0x10)
#define CLK_TEST_LPAIF_QUA_CLK_SRC ( CLK_LPASS_TEST|0x14)
#define CLK_TEST_AUDIO_CORE_RESAMPLER_CORE_CLK ( CLK_LPASS_TEST|0x3B)
#define CLK_TEST_RESAMPLER_CLK_SRC ( CLK_LPASS_TEST|0x6)
#define CLK_TEST_AUDIO_CORE_SLIMBUS_CORE_CLK ( CLK_LPASS_TEST|0x3D)
#define CLK_TEST_SLIMBUS_CLK_SRC ( CLK_LPASS_TEST|0x11)
#define CLK_TEST_AUDIO_WRAPPER_SPDMTM_CLK ( CLK_LPASS_TEST|0x1C)
#define CLK_TEST_SPDM_CLK_SRC ( CLK_LPASS_TEST|0x7)
#define CLK_TEST_LPAIF_SEC_CLK_SRC ( CLK_LPASS_TEST|0x16)
#define CLK_TEST_LPAIF_PCM1_CLK_SRC ( CLK_LPASS_TEST|0x12)
#define CLK_TEST_AUDIO_CORE_BCR_SLP_CLK ( CLK_LPASS_TEST|0x29)
#define CLK_TEST_Q6SS_BCR_SLEEP_CLK ( CLK_LPASS_TEST|0x1B)
#define CLK_TEST_Q6SS_SLP_CLK ( CLK_LPASS_TEST|0x2A)
#define CLK_TEST_SLEEP_CLK_SRC ( CLK_LPASS_TEST|0xA)
#define CLK_TEST_LPAIF_SPKR_CLK_SRC ( CLK_LPASS_TEST|0x18)
#define CLK_TEST_LPAIF_TER_CLK_SRC ( CLK_LPASS_TEST|0x15)
//MSS Test Clocks
#define CLK_TEST_CLK_BBRX0 ( CLK_MSS_TEST|0x1C)
#define CLK_TEST_CLK_BBRX1 ( CLK_MSS_TEST|0x1D)
#define CLK_TEST_CLK_BBRX2 ( CLK_MSS_TEST|0x1E)
#define CLK_TEST_CLK_BBRX3 ( CLK_MSS_TEST|0x1F)
#define CLK_TEST_CLK_BUS_ATB ( CLK_MSS_TEST|0x33)
#define CLK_TEST_CLK_BUS_BRIDGE ( CLK_MSS_TEST|0x2F)
#define CLK_TEST_CLK_BUS_BRIDGE_MON ( CLK_MSS_TEST|0x0E)
#define CLK_TEST_CLK_BUS_COMBODAC_COMP ( CLK_MSS_TEST|0x2D)
#define CLK_TEST_CLK_BUS_COXM ( CLK_MSS_TEST|0x36)
#define CLK_TEST_CLK_BUS_CSR ( CLK_MSS_TEST|0x2E)
#define CLK_TEST_CLK_BUS_MODEM_BRIDGE_CX ( CLK_MSS_TEST|0x21)
#define CLK_TEST_CLK_BUS_MODEM_CX_TO_LS ( CLK_MSS_TEST|0x22)
#define CLK_TEST_CLK_BUS_NAV_CX_TO_LS ( CLK_MSS_TEST|0x24)
#define CLK_TEST_CLK_BUS_NC_HM_BRIDGE_CX ( CLK_MSS_TEST|0x23)
#define CLK_TEST_CLK_BUS_POST_MUX ( CLK_MSS_TEST|0x3D)
#define CLK_TEST_CLK_BUS_Q6 ( CLK_MSS_TEST|0x3B)
#define CLK_TEST_CLK_BUS_RBCPR ( CLK_MSS_TEST|0x39)
#define CLK_TEST_CLK_BUS_SLAVE_TIMEOUT ( CLK_MSS_TEST|0x31)
#define CLK_TEST_CLK_BUS_UIM0 ( CLK_MSS_TEST|0x34)
#define CLK_TEST_CLK_BUS_UIM1 ( CLK_MSS_TEST|0x35)
#define CLK_TEST_CLK_MODEM_CFG_AHB ( CLK_MSS_TEST|0x2C)
#define CLK_TEST_CLK_BIT_COXM_DIV ( CLK_MSS_TEST|0x37)
#define CLK_TEST_MPLL0_MAIN_MODEM_CX_TO_LS ( CLK_MSS_TEST|0x27)
#define CLK_TEST_MPLL1_EARLY_DIV3_MODEM_CX_TO_LS ( CLK_MSS_TEST|0x1A)
#define CLK_TEST_MPLL1_MAIN_MODEM_CX_TO_LS ( CLK_MSS_TEST|0x19)
#define CLK_TEST_CLK_MODEM_MTC ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_MODEM|0x2)
#define CLK_TEST_CLK_MP ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_MODEM|0x4)
#define CLK_TEST_CLK_TDEC ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_MODEM|0x5)
#define CLK_TEST_CLK_VPE ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_MODEM|0x3)
#define CLK_TEST_CLK_XO_MTC ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_MODEM|0x1)
#define CLK_TEST_MPLL1_EARLY_DIV3_NAV_CX_TO_LS ( CLK_MSS_TEST|0x25)
#define CLK_TEST_MPLL1_MAIN_NAV_CX_TO_LS ( CLK_MSS_TEST|0x26)
#define CLK_TEST_CLK_NAV_ADC1 ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_NAV|0x2)
#define CLK_TEST_CLK_NAV_MAIN ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_NAV|0x1)
#define CLK_TEST_CLK_NAV_XO ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_NAV|0x3)
#define CLK_TEST_MPLL1_EARLY_DIV5 ( CLK_MSS_TEST|0x1B)
#define CLK_TEST_MPLL1_OUT_EARLY_DIV5 ( CLK_MSS_TEST|0x3E)
#define CLK_TEST_MPLL0_DTEST ( CLK_MSS_TEST|0x12)
#define CLK_TEST_MPLL1_DTEST ( CLK_MSS_TEST|0x13)
#define CLK_TEST_MPLL2_DTEST ( CLK_MSS_TEST|0x14)
#define CLK_TEST_PLL_LOCK_DET_MPLL0 ( CLK_MSS_TEST|0x0A)
#define CLK_TEST_PLL_LOCK_DET_MPLL1 ( CLK_MSS_TEST|0x0B)
#define CLK_TEST_PLL_LOCK_DET_MPLL2 ( CLK_MSS_TEST|0x0C)
#define CLK_TEST_CLK_Q6 ( CLK_MSS_TEST|0x11)
#define CLK_TEST_CLK_Q6_MON ( CLK_MSS_TEST|0x0D)
#define CLK_TEST_MSS_QDSP6SS_AHB_M_CLK ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_Q6|0x4)
#define CLK_TEST_MSS_QDSP6SS_AHB_S_CLK ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_Q6|0x5)
#define CLK_TEST_MSS_QDSP6SS_APB_CLK ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_Q6|0xA)
#define CLK_TEST_MSS_QDSP6SS_ATB_CLK ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_Q6|0x9)
#define CLK_TEST_MSS_QDSP6SS_AXI_M_CLK ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_Q6|0x2)
#define CLK_TEST_MSS_QDSP6SS_JTAG_TCK ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_Q6|0x8)
#define CLK_TEST_MSS_QDSP6SS_LDO_NMO_OUT ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_Q6|0x3)
#define CLK_TEST_MSS_QDSP6SS_Q6_CORE_CLK ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_Q6|0x1)
#define CLK_TEST_MSS_QDSP6SS_SLEEP_CLK ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_Q6|0x7)
#define CLK_TEST_MSS_QDSP6SS_TIMESTAMP_CLK ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_Q6|0xB)
#define CLK_TEST_MSS_QDSP6SS_XO_CLK ( CLK_MSS_TEST| CLK_MSS_SUB_MUX_Q6|0x6)
#define CLK_TEST_CLK_BUS_RBCPR_REF ( CLK_MSS_TEST|0x3A)
#define CLK_TEST_BUS_SLAVE_TIMEOUT_TIME_BASE ( CLK_MSS_TEST|0x32)
#define CLK_TEST_CLK_SLEEP_Q6 ( CLK_MSS_TEST|0x09)
#define CLK_TEST_CLK_MODEM_SNOC_AXI ( CLK_MSS_TEST|0x2A)
#define CLK_TEST_CLK_NAV_SNOC_AXI ( CLK_MSS_TEST|0x2B)
#define CLK_TEST_CLK_VMIDMT_SNOC_AXI ( CLK_MSS_TEST|0x29)
#define CLK_TEST_CLK_UIM_DIV ( CLK_MSS_TEST|0x0F)
#define CLK_TEST_CLK_UIM0 ( CLK_MSS_TEST|0x02)
#define CLK_TEST_CLK_XO_UIM0 ( CLK_MSS_TEST|0x04)
#define CLK_TEST_CLK_UIM1 ( CLK_MSS_TEST|0x03)
#define CLK_TEST_CLK_XO_UIM1 ( CLK_MSS_TEST|0x05)
#define CLK_TEST_CLK_XO_DIV12 ( CLK_MSS_TEST|0x01)
#define CLK_TEST_CLK_XO_MODEM_CX_TO_LS ( CLK_MSS_TEST|0x06)
#define CLK_TEST_CLK_XO_Q6 ( CLK_MSS_TEST|0x07)
// MMSS Test Clocks
#define CLK_TEST_CAMSS_CCI_CCI_AHB_CLK ( CLK_MMSS_TEST|0x2e)
#define CLK_TEST_CAMSS_CCI_CCI_CLK ( CLK_MMSS_TEST|0x2d)
#define CLK_TEST_CAMSS_CSI0_AHB_CLK ( CLK_MMSS_TEST|0x42)
#define CLK_TEST_CAMSS_CSI0_CLK ( CLK_MMSS_TEST|0x41)
#define CLK_TEST_CAMSS_CSI0PHY_CLK ( CLK_MMSS_TEST|0x43)
#define CLK_TEST_CAMSS_CSI0PIX_CLK ( CLK_MMSS_TEST|0x45)
#define CLK_TEST_CAMSS_CSI0RDI_CLK ( CLK_MMSS_TEST|0x44)
#define CLK_TEST_CAMSS_CSI1_AHB_CLK ( CLK_MMSS_TEST|0x47)
#define CLK_TEST_CAMSS_CSI1_CLK ( CLK_MMSS_TEST|0x46)
#define CLK_TEST_CAMSS_CSI1PHY_CLK ( CLK_MMSS_TEST|0x48)
#define CLK_TEST_CAMSS_CSI1PIX_CLK ( CLK_MMSS_TEST|0x4a)
#define CLK_TEST_CAMSS_CSI1RDI_CLK ( CLK_MMSS_TEST|0x49)
#define CLK_TEST_CAMSS_CSI2_AHB_CLK ( CLK_MMSS_TEST|0x4c)
#define CLK_TEST_CAMSS_CSI2_CLK ( CLK_MMSS_TEST|0x4b)
#define CLK_TEST_CAMSS_CSI2PHY_CLK ( CLK_MMSS_TEST|0x4d)
#define CLK_TEST_CAMSS_CSI2PIX_CLK ( CLK_MMSS_TEST|0x4f)
#define CLK_TEST_CAMSS_CSI2RDI_CLK ( CLK_MMSS_TEST|0x4e)
#define CLK_TEST_CAMSS_CSI3_AHB_CLK ( CLK_MMSS_TEST|0x51)
#define CLK_TEST_CAMSS_CSI3_CLK ( CLK_MMSS_TEST|0x50)
#define CLK_TEST_CAMSS_CSI3PHY_CLK ( CLK_MMSS_TEST|0x52)
#define CLK_TEST_CAMSS_CSI3PIX_CLK ( CLK_MMSS_TEST|0x54)
#define CLK_TEST_CAMSS_CSI3RDI_CLK ( CLK_MMSS_TEST|0x53)
#define CLK_TEST_CAMSS_CSI_VFE0_CLK ( CLK_MMSS_TEST|0x3f)
#define CLK_TEST_CAMSS_CSI_VFE1_CLK ( CLK_MMSS_TEST|0x40)
#define CLK_TEST_CAMSS_GP0_CLK ( CLK_MMSS_TEST|0x27)
#define CLK_TEST_CAMSS_GP1_CLK ( CLK_MMSS_TEST|0x28)
#define CLK_TEST_CAMSS_ISPIF_AHB_CLK ( CLK_MMSS_TEST|0x55)
#define CLK_TEST_CAMSS_JPEG_JPEG0_CLK ( CLK_MMSS_TEST|0x32)
#define CLK_TEST_CAMSS_JPEG_JPEG1_CLK ( CLK_MMSS_TEST|0x33)
#define CLK_TEST_CAMSS_JPEG_JPEG2_CLK ( CLK_MMSS_TEST|0x34)
#define CLK_TEST_CAMSS_JPEG_JPEG_AHB_CLK ( CLK_MMSS_TEST|0x35)
#define CLK_TEST_CAMSS_JPEG_JPEG_AXI_CLK ( CLK_MMSS_TEST|0x36)
#define CLK_TEST_CAMSS_JPEG_JPEG_OCMEMNOC_CLK ( CLK_MMSS_TEST|0x37)
#define CLK_TEST_CAMSS_MCLK0_CLK ( CLK_MMSS_TEST|0x29)
#define CLK_TEST_CAMSS_MCLK1_CLK ( CLK_MMSS_TEST|0x2a)
#define CLK_TEST_CAMSS_MCLK2_CLK ( CLK_MMSS_TEST|0x2b)
#define CLK_TEST_CAMSS_MCLK3_CLK ( CLK_MMSS_TEST|0x2c)
#define CLK_TEST_CAMSS_MICRO_AHB_CLK ( CLK_MMSS_TEST|0x26)
#define CLK_TEST_CAMSS_PHY0_CSI0PHYTIMER_CLK ( CLK_MMSS_TEST|0x2f)
#define CLK_TEST_CAMSS_PHY1_CSI1PHYTIMER_CLK ( CLK_MMSS_TEST|0x30)
#define CLK_TEST_CAMSS_PHY2_CSI2PHYTIMER_CLK ( CLK_MMSS_TEST|0x31)
#define CLK_TEST_CAMSS_TOP_AHB_CLK ( CLK_MMSS_TEST|0x25)
#define CLK_TEST_CAMSS_VFE_CPP_AHB_CLK ( CLK_MMSS_TEST|0x3b)
#define CLK_TEST_CAMSS_VFE_CPP_CLK ( CLK_MMSS_TEST|0x3a)
#define CLK_TEST_CAMSS_VFE_VFE0_CLK ( CLK_MMSS_TEST|0x38)
#define CLK_TEST_CAMSS_VFE_VFE1_CLK ( CLK_MMSS_TEST|0x39)
#define CLK_TEST_CAMSS_VFE_VFE_AHB_CLK ( CLK_MMSS_TEST|0x3c)
#define CLK_TEST_CAMSS_VFE_VFE_AXI_CLK ( CLK_MMSS_TEST|0x3d)
#define CLK_TEST_CAMSS_VFE_VFE_OCMEMNOC_CLK ( CLK_MMSS_TEST|0x3e)
#define CLK_TEST_MDSS_AHB_CLK ( CLK_MMSS_TEST|0x22)
#define CLK_TEST_MDSS_AXI_CLK ( CLK_MMSS_TEST|0x24)
#define CLK_TEST_MDSS_BYTE0_CLK ( CLK_MMSS_TEST|0x1e)
#define CLK_TEST_MDSS_BYTE1_CLK ( CLK_MMSS_TEST|0x1f)
#define CLK_TEST_MDSS_EDPAUX_CLK ( CLK_MMSS_TEST|0x1b)
#define CLK_TEST_MDSS_EDPLINK_CLK ( CLK_MMSS_TEST|0x1a)
#define CLK_TEST_MDSS_EDPPIXEL_CLK ( CLK_MMSS_TEST|0x19)
#define CLK_TEST_MDSS_ESC0_CLK ( CLK_MMSS_TEST|0x20)
#define CLK_TEST_MDSS_ESC1_CLK ( CLK_MMSS_TEST|0x21)
#define CLK_TEST_MDSS_EXTPCLK_CLK ( CLK_MMSS_TEST|0x18)
#define CLK_TEST_MDSS_HDMI_AHB_CLK ( CLK_MMSS_TEST|0x23)
#define CLK_TEST_MDSS_HDMI_CLK ( CLK_MMSS_TEST|0x1d)
#define CLK_TEST_MDSS_MDP_CLK ( CLK_MMSS_TEST|0x14)
#define CLK_TEST_MDSS_MDP_LUT_CLK ( CLK_MMSS_TEST|0x15)
#define CLK_TEST_MDSS_PCLK0_CLK ( CLK_MMSS_TEST|0x16)
#define CLK_TEST_MDSS_PCLK1_CLK ( CLK_MMSS_TEST|0x17)
#define CLK_TEST_MDSS_VSYNC_CLK ( CLK_MMSS_TEST|0x1c)
#define CLK_TEST_MMSS_MISC_AHB_CLK ( CLK_MMSS_TEST|0x3)
#define CLK_TEST_MMSS_MMSSNOC_AHB_CLK ( CLK_MMSS_TEST|0x1)
#define CLK_TEST_MMSS_MMSSNOC_BTO_AHB_CLK ( CLK_MMSS_TEST|0x2)
#define CLK_TEST_MMSS_MMSSNOC_AXI_CLK ( CLK_MMSS_TEST|0x4)
#define CLK_TEST_MMSS_S0_AXI_CLK ( CLK_MMSS_TEST|0x5)
#define CLK_TEST_MMSS_RBCPR_AHB_CLK ( CLK_MMSS_TEST|0x13)
#define CLK_TEST_MMSS_RBCPR_CLK ( CLK_MMSS_TEST|0x12)
#define CLK_TEST_MMSS_SPDM_AHB_CLK ( CLK_MMSS_TEST|0x60)
#define CLK_TEST_MMSS_SPDM_AXI_CLK ( CLK_MMSS_TEST|0x59)
#define CLK_TEST_MMSS_SPDM_CSI0_CLK ( CLK_MMSS_TEST|0x63)
#define CLK_TEST_MMSS_SPDM_GFX3D_CLK ( CLK_MMSS_TEST|0x5f)
#define CLK_TEST_MMSS_SPDM_JPEG0_CLK ( CLK_MMSS_TEST|0x56)
#define CLK_TEST_MMSS_SPDM_JPEG1_CLK ( CLK_MMSS_TEST|0x57)
#define CLK_TEST_MMSS_SPDM_JPEG2_CLK ( CLK_MMSS_TEST|0x5d)
#define CLK_TEST_MMSS_SPDM_MDP_CLK ( CLK_MMSS_TEST|0x58)
#define CLK_TEST_MMSS_SPDM_OCMEMNOC_CLK ( CLK_MMSS_TEST|0x62)
#define CLK_TEST_MMSS_SPDM_PCLK0_CLK ( CLK_MMSS_TEST|0x61)
#define CLK_TEST_MMSS_SPDM_PCLK1_CLK ( CLK_MMSS_TEST|0x5e)
#define CLK_TEST_MMSS_SPDM_VCODEC0_CLK ( CLK_MMSS_TEST|0x5a)
#define CLK_TEST_MMSS_SPDM_VFE0_CLK ( CLK_MMSS_TEST|0x5b)
#define CLK_TEST_MMSS_SPDM_VFE1_CLK ( CLK_MMSS_TEST|0x5c)
#define CLK_TEST_MMSS_SPDM_RM_AXI_CLK ( CLK_MMSS_TEST|0x64)
#define CLK_TEST_MMSS_SPDM_RM_OCMEMNOC_CLK ( CLK_MMSS_TEST|0x65)
#define CLK_TEST_GCC_OCMEM_SYS_NOC_AXI_CLK ( CLK_MMSS_TEST|0x8)
#define CLK_TEST_OCMEMCX_AHB_CLK ( CLK_MMSS_TEST|0xa)
#define CLK_TEST_OCMEMCX_OCMEMNOC_CLK ( CLK_MMSS_TEST|0x9)
#define CLK_TEST_OCMEMNOC_CLK ( CLK_MMSS_TEST|0x7)
#define CLK_TEST_GFX3D_CLK_SRC ( CLK_MMSS_TEST|0xd)
#define CLK_TEST_OXILICX_AHB_CLK ( CLK_MMSS_TEST|0xc)
#define CLK_TEST_OXILICX_AXI_CLK ( CLK_MMSS_TEST|0xb)
#define CLK_TEST_VENUS0_AHB_CLK ( CLK_MMSS_TEST|0x11)
#define CLK_TEST_VENUS0_AXI_CLK ( CLK_MMSS_TEST|0xf)
#define CLK_TEST_VENUS0_OCMEMNOC_CLK ( CLK_MMSS_TEST|0x10)
#define CLK_TEST_VENUS0_VCODEC0_CLK ( CLK_MMSS_TEST|0xe)

// WCSS Test Clocks
#define CLK_TEST_WCSS_BT_32M_CLK_SRC ( CLK_WCSS_TEST|0xD)
#define CLK_TEST_WCSS_BT_FM_19M_CLK_SRC ( CLK_WCSS_TEST|0xE)
#define CLK_TEST_WCSS_COMMON_AHB_CLK ( CLK_WCSS_TEST|0x15)
#define CLK_TEST_WCSS_COMMON_BT_32M_CLK ( CLK_WCSS_TEST|0x18)
#define CLK_TEST_WCSS_COMMON_BT_FM_19M_CLK ( CLK_WCSS_TEST|0x19)
#define CLK_TEST_WCSS_COMMON_CPU_CLK ( CLK_WCSS_TEST|0x14)
#define CLK_TEST_WCSS_COMMON_PHY_DBG_CLK ( CLK_WCSS_TEST|0x17)
#define CLK_TEST_WCSS_COMMON_SLP_CLK ( CLK_WCSS_TEST|0x1A)
#define CLK_TEST_WCSS_COMMON_TRC_CLK ( CLK_WCSS_TEST|0x16)
#define CLK_TEST_WCSS_COMMON_XO_CLK ( CLK_WCSS_TEST|0x1B)
#define CLK_TEST_O_WCSS_AHB_S0_CLK ( CLK_WCSS_TEST|0x27)
#define CLK_TEST_O_WCSS_AXI_M_CLK ( CLK_WCSS_TEST|0x26)
#define CLK_TEST_O_WCSS_BUS_TIMEOUT_CLK ( CLK_WCSS_TEST|0x2A)
#define CLK_TEST_WCSS_CPU_AHB_CLK_SRC ( CLK_WCSS_TEST|0xb)
#define CLK_TEST_WCSS_SLP_CLK_SRC ( CLK_WCSS_TEST|0xF)
#define CLK_TEST_WCSS_TOP_AHB_CLK ( CLK_WCSS_TEST|0x11)
#define CLK_TEST_WCSS_TOP_SLP_CLK ( CLK_WCSS_TEST|0x12)
#define CLK_TEST_WCSS_TOP_XO_CLK ( CLK_WCSS_TEST|0x13)
#define CLK_TEST_WCSS_XO_CLK_SRC ( CLK_WCSS_TEST|0x10)
#define CLK_TEST_O_WCSS_ADC_240M_CLK ( CLK_WCSS_TEST|0x22)
#define CLK_TEST_WCSS_DAC_SM_CLK ( CLK_WCSS_TEST|0x13)
#define CLK_TEST_WCSS_RFIF_CLK_SRC ( CLK_WCSS_TEST|0xA)
#define CLK_TEST_WCSS_WLAN_ADC_CLK ( CLK_WCSS_TEST|0x23)
#define CLK_TEST_WCSS_WLAN_AHB_CLK ( CLK_WCSS_TEST|0x25)
#define CLK_TEST_WCSS_WLAN_PHY_DAC_CLK ( CLK_WCSS_TEST|0x21)
#define CLK_TEST_WCSS_WLAN_PHY_DBG_CLK ( CLK_WCSS_TEST|0x20)
#define CLK_TEST_WCSS_WLAN_PHY_MAIN1_FAST_CLK ( CLK_WCSS_TEST|0x1C)
#define CLK_TEST_WCSS_WLAN_RFA_CAL_CLK ( CLK_WCSS_TEST|0x29)
#define CLK_TEST_WCSS_WLAN_RFIF_CLK ( CLK_WCSS_TEST|0x24)
#define CLK_TEST_WLAN_PHY_MAIN1_RX_CLK ( CLK_WCSS_TEST|0x1E)
#define CLK_TEST_WLAN_PHY_MAIN1_TX_CLK ( CLK_WCSS_TEST|0x1D)
#define CLK_TEST_WLAN_PHY_MAIN2_CLK ( CLK_WCSS_TEST|0x1F)

//  APCS Test Clocks
#define CLK_TEST_APCS_C0_CLK ( CLK_APCS_TEST|0x00)
#define CLK_TEST_APCS_C1_CLK ( CLK_APCS_TEST|0x08)
#define CLK_TEST_APCS_C2_CLK ( CLK_APCS_TEST|0x10)
#define CLK_TEST_APCS_C3_CLK ( CLK_APCS_TEST|0x18)
#define CLK_TEST_APCS_L2_CLK ( CLK_APCS_TEST|0x01)
#define CLK_TEST_APCS_SPISLEEP_CLK ( CLK_APCS_TEST|0x07)
#define CLK_TEST_APCS_SYSAHB_CLK ( CLK_APCS_TEST|0x04)
#define CLK_TEST_APCS_SYSQSB_CLK ( CLK_APCS_TEST|0x03)
#define CLK_TEST_APCS_SYSREF_CLK ( CLK_APCS_TEST|0x06)


#define CLK_MMSS_TEST (0x4<<0xC)
#define CLK_TEST_SEL_MASK (0x0000F000)

#define CLK_TEST_TYPE_MASK (0x00000FFF)
#define CLK_TEST_SUB_MUX_MASK (0xF0000000)

#endif
	
