/* Copyright (c) 2013, Samsung Electronics Co. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {4294, 4316, 4327, 4328, 4318},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1398, 289, 100, 83, 78},
				{1383, 297, 103, 85, 79},
				{1383, 296, 103, 84, 79},
				{1376, 300, 106, 86, 80},
				{1331, 297, 110, 88, 81},
				{1248, 302, 119, 93, 83},
				{1232, 283, 123, 95, 85},
				{1223, 281, 122, 103, 90},
				{1230, 282, 106, 89, 83},
				{1253, 280, 101, 84, 80},
				{1287, 283, 101, 86, 80},
				{1333, 285, 104, 88, 82},
				{1384, 285, 106, 90, 84},
				{1439, 283, 107, 89, 84},
				{1500, 283, 107, 87, 82},
				{1574, 293, 105, 85, 81},
				{1659, 320, 105, 85, 80},
				{1749, 354, 103, 84, 80},
				{1853, 386, 100, 84, 80},
				{1990, 407, 104, 86, 81},
				{2058, 414, 106, 88, 82},
				{2120, 414, 111, 90, 83},
				{2178, 403, 114, 91, 84},
				{1938, 367, 119, 92, 85},
				{2026, 375, 121, 92, 83},
				{2358, 380, 118, 89, 82},
				{2839, 394, 112, 86, 82},
				{3641, 403, 111, 89, 83},
				{5186, 420, 115, 93, 92},
				{11656, 3216, 2786, 600, 1146},
	}
};

static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4319, 4319, 4314, 4309, 4302},
				{4217, 4249, 4252, 4249, 4245},
				{4142, 4193, 4199, 4197, 4193},
				{4090, 4139, 4149, 4146, 4142},
				{4030, 4087, 4100, 4097, 4093},
				{3953, 4036, 4062, 4057, 4048},
				{3904, 3964, 3998, 4002, 4005},
				{3863, 3922, 3952, 3962, 3962},
				{3832, 3892, 3906, 3910, 3910},
				{3808, 3862, 3872, 3873, 3873},
				{3788, 3834, 3846, 3847, 3847},
				{3769, 3810, 3823, 3824, 3824},
				{3750, 3786, 3804, 3805, 3805},
				{3731, 3765, 3786, 3786, 3785},
				{3710, 3746, 3769, 3768, 3760},
				{3686, 3731, 3751, 3747, 3736},
				{3658, 3719, 3727, 3722, 3709},
				{3629, 3707, 3704, 3698, 3685},
				{3604, 3696, 3691, 3682, 3671},
				{3581, 3684, 3689, 3681, 3669},
				{3569, 3677, 3687, 3680, 3668},
				{3554, 3667, 3686, 3679, 3667},
				{3538, 3656, 3684, 3678, 3665},
				{3521, 3642, 3679, 3674, 3659},
				{3500, 3624, 3665, 3662, 3641},
				{3475, 3599, 3637, 3633, 3602},
				{3444, 3568, 3591, 3584, 3549},
				{3405, 3521, 3525, 3519, 3477},
				{3352, 3447, 3427, 3425, 3376},
				{3264, 3307, 3275, 3277, 3220},
				{3000, 3000, 3000, 3000, 3000}
	}
};

struct bms_battery_data samsung_4450mAH_data = {
	.fcc				= 4450,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 130
};
