/*
 * Copyright (c) 2012-2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/of.h>
#include <mach/rpm-regulator-smd.h>
#include <mach/msm_bus_board.h>
#include <mach/msm_bus.h>
#include <mach/socinfo.h>

#include "acpuclock.h"
#include "acpuclock-krait.h"

/* Corner type vreg VDD values */
#define LVL_NONE	RPM_REGULATOR_CORNER_NONE
#define LVL_LOW		RPM_REGULATOR_CORNER_SVS_SOC
#define LVL_NOM		RPM_REGULATOR_CORNER_NORMAL
#define LVL_HIGH	RPM_REGULATOR_CORNER_SUPER_TURBO

static struct hfpll_data hfpll_data __initdata = {
	.mode_offset = 0x00,
	.l_offset = 0x04,
	.m_offset = 0x08,
	.n_offset = 0x0C,
	.has_user_reg = true,
	.user_offset = 0x10,
	.config_offset = 0x14,
	.user_val = 0x8,
	.user_vco_mask = BIT(20),
	.config_val = 0x04D0405D,
	.has_lock_status = true,
	.status_offset = 0x1C,
	.low_vco_l_max = 65,
	.low_vdd_l_max = 52,
	.nom_vdd_l_max = 104,
	.vdd[HFPLL_VDD_NONE] = LVL_NONE,
	.vdd[HFPLL_VDD_LOW]  = LVL_LOW,
	.vdd[HFPLL_VDD_NOM]  = LVL_NOM,
	.vdd[HFPLL_VDD_HIGH] = LVL_HIGH,
};

static struct scalable scalable[] __initdata = {
	[CPU0] = {
		.hfpll_phys_base = 0xF908A000,
		.l2cpmr_iaddr = 0x4501,
		.sec_clk_sel = 2,
		.vreg[VREG_CORE] = { "krait0",     1120000 },
		.vreg[VREG_MEM]  = { "krait0_mem", 1050000 },
		.vreg[VREG_DIG]  = { "krait0_dig", LVL_HIGH },
		.vreg[VREG_HFPLL_A] = { "krait0_hfpll", 1800000 },
	},
	[CPU1] = {
		.hfpll_phys_base = 0xF909A000,
		.l2cpmr_iaddr = 0x5501,
		.sec_clk_sel = 2,
		.vreg[VREG_CORE] = { "krait1",     1120000 },
		.vreg[VREG_MEM]  = { "krait1_mem", 1050000 },
		.vreg[VREG_DIG]  = { "krait1_dig", LVL_HIGH },
		.vreg[VREG_HFPLL_A] = { "krait1_hfpll", 1800000 },
	},
	[CPU2] = {
		.hfpll_phys_base = 0xF90AA000,
		.l2cpmr_iaddr = 0x6501,
		.sec_clk_sel = 2,
		.vreg[VREG_CORE] = { "krait2",     1120000 },
		.vreg[VREG_MEM]  = { "krait2_mem", 1050000 },
		.vreg[VREG_DIG]  = { "krait2_dig", LVL_HIGH },
		.vreg[VREG_HFPLL_A] = { "krait2_hfpll", 1800000 },
	},
	[CPU3] = {
		.hfpll_phys_base = 0xF90BA000,
		.l2cpmr_iaddr = 0x7501,
		.sec_clk_sel = 2,
		.vreg[VREG_CORE] = { "krait3",     1120000 },
		.vreg[VREG_MEM]  = { "krait3_mem", 1050000 },
		.vreg[VREG_DIG]  = { "krait3_dig", LVL_HIGH },
		.vreg[VREG_HFPLL_A] = { "krait3_hfpll", 1800000 },
	},
	[L2] = {
		.hfpll_phys_base = 0xF9016000,
		.l2cpmr_iaddr = 0x0500,
		.sec_clk_sel = 2,
		.vreg[VREG_HFPLL_A] = { "l2_hfpll", 1800000 },
	},
};

static struct msm_bus_paths bw_level_tbl[] __initdata = {
	[0] =  BW_MBPS(600), /* At least  75 MHz on bus. */
	[1] =  BW_MBPS(800), /* At least 100 MHz on bus. */
	[2] = BW_MBPS(1200), /* At least 150 MHz on bus. */
	[3] = BW_MBPS(1600), /* At least 200 MHz on bus. */
	[4] = BW_MBPS(2456), /* At least 307 MHz on bus. */
	[5] = BW_MBPS(3680), /* At least 460 MHz on bus. */
	[6] = BW_MBPS(4912), /* At least 614 MHz on bus. */
	[7] = BW_MBPS(6400), /* At least 800 MHz on bus. */
	[8] = BW_MBPS(7448), /* At least 931 MHz on bus. */
};

static struct l2_level l2_freq_tbl[] __initdata = {
	[0]  = { {  300000, PLL_0, 0,   0 }, LVL_LOW,   950000, 0 },
	[1]  = { {  345600, HFPLL, 2,  36 }, LVL_LOW,   950000, 1 },
	[2]  = { {  422400, HFPLL, 2,  44 }, LVL_LOW,   950000, 2 },
	[3]  = { {  499200, HFPLL, 2,  52 }, LVL_LOW,   950000, 3 },
	[4]  = { {  576000, HFPLL, 1,  30 }, LVL_LOW,   950000, 4 },
	[5]  = { {  652800, HFPLL, 1,  34 }, LVL_NOM,   950000, 4 },
	[6]  = { {  729600, HFPLL, 1,  38 }, LVL_NOM,   950000, 4 },
	[7]  = { {  806400, HFPLL, 1,  42 }, LVL_NOM,   950000, 4 },
	[8]  = { {  883200, HFPLL, 1,  46 }, LVL_NOM,   950000, 5 },
	[9]  = { {  960000, HFPLL, 1,  50 }, LVL_NOM,   950000, 5 },
	[10] = { { 1036800, HFPLL, 1,  54 }, LVL_NOM,   950000, 5 },
	[11] = { { 1113600, HFPLL, 1,  58 }, LVL_HIGH, 1050000, 6 },
	[12] = { { 1190400, HFPLL, 1,  62 }, LVL_HIGH, 1050000, 6 },
	[13] = { { 1267200, HFPLL, 1,  66 }, LVL_HIGH, 1050000, 6 },
	[14] = { { 1344000, HFPLL, 1,  70 }, LVL_HIGH, 1050000, 6 },
	[15] = { { 1420800, HFPLL, 1,  74 }, LVL_HIGH, 1050000, 6 },
	[16] = { { 1497600, HFPLL, 1,  78 }, LVL_HIGH, 1050000, 6 },
	[17] = { { 1574400, HFPLL, 1,  82 }, LVL_HIGH, 1050000, 7 },
	[18] = { { 1651200, HFPLL, 1,  86 }, LVL_HIGH, 1050000, 7 },
	[19] = { { 1728000, HFPLL, 1,  90 }, LVL_HIGH, 1050000, 8 },
	{ }
};

static struct acpu_level acpu_freq_tbl_2g_pvs0[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  815000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  825000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  835000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  845000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  855000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  865000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  875000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  890000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  900000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  915000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  925000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  940000, 298 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  950000, 321 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  965000, 346 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  980000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  995000, 397 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16), 1010000, 423 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17), 1025000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17), 1040000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18), 1055000, 506 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1070000, 536 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1085000, 567 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1100000, 598 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2g_pvs1[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  810000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  820000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  830000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  840000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  850000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  860000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  875000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  885000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  895000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  910000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  920000, 298 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  930000, 321 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  945000, 346 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  960000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  975000, 397 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  990000, 423 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17), 1005000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17), 1020000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18), 1030000, 506 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1045000, 536 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1060000, 567 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1075000, 598 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2g_pvs2[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  785000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  795000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  805000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  815000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  825000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  835000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  845000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  855000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  865000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  875000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  890000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  900000, 298 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  910000, 321 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  925000, 346 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  940000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  955000, 397 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  970000, 423 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  980000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  995000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18), 1005000, 506 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1020000, 536 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1035000, 567 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1050000, 598 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2g_pvs3[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  780000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  790000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  810000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  820000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  830000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  840000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  850000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  860000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  875000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  885000, 298 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  895000, 321 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  910000, 346 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  925000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  935000, 397 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  950000, 423 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  960000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  970000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  985000, 506 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  995000, 536 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1010000, 567 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1025000, 598 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2g_pvs4[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  780000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  790000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  800000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  810000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  820000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  830000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  840000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  850000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  860000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  870000, 298 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  880000, 321 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  895000, 346 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  910000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  920000, 397 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  930000, 423 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  940000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  950000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  960000, 506 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  975000, 536 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  985000, 567 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1000000, 598 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2g_pvs5[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  760000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  770000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  780000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  790000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  800000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  810000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  820000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  830000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  840000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  850000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  860000, 298 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  870000, 321 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  880000, 346 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  890000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  900000, 397 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  910000, 423 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  920000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  930000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  940000, 506 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  955000, 536 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  965000, 567 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  975000, 598 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2g_pvs6[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  73 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  760000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  770000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  780000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  790000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  800000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  810000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  820000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  830000, 252 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  840000, 275 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  850000, 298 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  860000, 321 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  870000, 346 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  875000, 371 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  885000, 397 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  895000, 423 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  905000, 450 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  915000, 477 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  920000, 506 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  930000, 536 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  940000, 567 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  950000, 598 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p2g_pvs0[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  805000, 102 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  815000, 121 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  825000, 141 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  835000, 161 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  845000, 181 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  855000, 202 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  865000, 223 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  875000, 245 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  890000, 267 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  900000, 289 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  915000, 313 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  925000, 336 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  940000, 360 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  950000, 383 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  965000, 409 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  980000, 435 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  995000, 461 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18), 1010000, 488 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1025000, 516 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1040000, 543 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1055000, 573 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1070000, 604 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1085000, 636 },
	{ 1, { 2150400, HFPLL, 1, 112 }, L2(19), 1100000, 656 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p2g_pvs1[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 102 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 121 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  810000, 141 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  820000, 161 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  830000, 181 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  840000, 202 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  850000, 223 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  860000, 245 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  875000, 267 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  885000, 289 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  895000, 313 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  910000, 336 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  920000, 360 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  930000, 383 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  945000, 409 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  960000, 435 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  975000, 461 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  990000, 488 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1005000, 516 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1020000, 543 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1030000, 573 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1045000, 604 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1060000, 636 },
	{ 1, { 2150400, HFPLL, 1, 112 }, L2(19), 1075000, 656 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p2g_pvs2[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 102 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  785000, 121 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  795000, 141 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  805000, 161 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  815000, 181 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  825000, 202 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  835000, 223 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  845000, 245 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  855000, 267 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  865000, 289 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  875000, 313 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  890000, 336 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  900000, 360 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  910000, 383 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  925000, 409 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  940000, 435 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  955000, 461 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  970000, 488 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  980000, 516 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  995000, 543 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1005000, 573 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1020000, 604 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1035000, 636 },
	{ 1, { 2150400, HFPLL, 1, 112 }, L2(19), 1050000, 656 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p2g_pvs3[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 102 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 121 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  780000, 141 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  790000, 161 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  800000, 181 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  810000, 202 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  820000, 223 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  830000, 245 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  840000, 267 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  850000, 289 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  860000, 313 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  875000, 336 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  885000, 360 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  895000, 383 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  910000, 409 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  925000, 435 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  935000, 461 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  950000, 488 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  960000, 516 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  970000, 543 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  985000, 573 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  995000, 604 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1010000, 636 },
	{ 1, { 2150400, HFPLL, 1, 112 }, L2(19), 1025000, 656 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p2g_pvs4[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 102 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 121 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 141 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  780000, 161 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  790000, 181 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  800000, 202 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  810000, 223 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  820000, 245 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  830000, 267 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  840000, 289 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  850000, 313 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  860000, 336 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  870000, 360 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  880000, 383 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  895000, 409 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  910000, 435 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  920000, 461 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  930000, 488 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  940000, 516 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  950000, 543 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  960000, 573 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  975000, 604 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  985000, 636 },
	{ 1, { 2150400, HFPLL, 1, 112 }, L2(19), 1000000, 656 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p2g_pvs5[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 102 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 121 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  760000, 141 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  770000, 161 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  780000, 181 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  790000, 202 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  800000, 223 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  810000, 245 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  820000, 267 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  830000, 289 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  840000, 313 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  850000, 336 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  860000, 360 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  870000, 383 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  880000, 409 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  890000, 435 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  900000, 461 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  910000, 488 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  920000, 516 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  930000, 543 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  940000, 573 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  955000, 604 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  965000, 636 },
	{ 1, { 2150400, HFPLL, 1, 112 }, L2(19),  975000, 656 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p2g_pvs6[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 102 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 121 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  750000, 141 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  760000, 161 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  770000, 181 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  780000, 202 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  790000, 223 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  800000, 245 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  810000, 267 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  820000, 289 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  830000, 313 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  840000, 336 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  850000, 360 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  860000, 383 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  870000, 409 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  875000, 435 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  885000, 461 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  895000, 488 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  905000, 516 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  915000, 543 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  920000, 573 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  930000, 604 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  940000, 636 },
	{ 1, { 2150400, HFPLL, 1, 112 }, L2(19),  950000, 656 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p3g_pvs0[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 101 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  805000, 120 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  815000, 139 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  825000, 159 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  835000, 180 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  845000, 200 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  855000, 221 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  865000, 242 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  875000, 264 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  890000, 287 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  900000, 308 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  915000, 333 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  925000, 356 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  940000, 380 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  950000, 404 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  965000, 430 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  980000, 456 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  995000, 482 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1010000, 510 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1025000, 538 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1040000, 565 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1055000, 596 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1070000, 627 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1085000, 659 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1100000, 691 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p3g_pvs1[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 101 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 120 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  800000, 139 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  810000, 159 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  820000, 180 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  830000, 200 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  840000, 221 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  850000, 242 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  860000, 264 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  875000, 287 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  885000, 308 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  895000, 333 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  910000, 356 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  920000, 380 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  930000, 404 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  945000, 430 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  960000, 456 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  975000, 482 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  990000, 510 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1005000, 538 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1020000, 565 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1030000, 596 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1045000, 627 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1060000, 659 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1075000, 691 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p3g_pvs2[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 101 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 120 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  785000, 139 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  795000, 159 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  805000, 180 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  815000, 200 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  825000, 221 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  835000, 242 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  845000, 264 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  855000, 287 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  865000, 308 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  875000, 333 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  890000, 356 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  900000, 380 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  910000, 404 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  925000, 430 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  940000, 456 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  955000, 482 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  970000, 510 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  980000, 538 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  995000, 565 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1005000, 596 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1020000, 627 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1035000, 659 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1050000, 691 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p3g_pvs3[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 101 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 120 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 139 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  780000, 159 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  790000, 180 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  800000, 200 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  810000, 221 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  820000, 242 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  830000, 264 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  840000, 287 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  850000, 308 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  860000, 333 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  875000, 356 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  885000, 380 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  895000, 404 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  910000, 430 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  925000, 456 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  935000, 482 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  950000, 510 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  960000, 538 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  970000, 565 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  985000, 596 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  995000, 627 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1010000, 659 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1025000, 691 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p3g_pvs4[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 101 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 120 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 139 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 159 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  780000, 180 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  790000, 200 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  800000, 221 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  810000, 242 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  820000, 264 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  830000, 287 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  840000, 308 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  850000, 333 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  860000, 356 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  870000, 380 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  880000, 404 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  895000, 430 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  910000, 456 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  920000, 482 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  930000, 510 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  940000, 538 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  950000, 565 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  960000, 596 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  975000, 627 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  985000, 659 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1000000, 691 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p3g_pvs5[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 101 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 120 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  750000, 139 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  760000, 159 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  770000, 180 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  780000, 200 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  790000, 221 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  800000, 242 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  810000, 264 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  820000, 287 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  830000, 308 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  840000, 333 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  850000, 356 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  860000, 380 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  870000, 404 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  880000, 430 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  890000, 456 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  900000, 482 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  910000, 510 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  920000, 538 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  930000, 565 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  940000, 596 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  955000, 627 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  965000, 659 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  975000, 691 },
	{ 0, { 0 } }
};

static struct acpu_level acpu_freq_tbl_2p3g_pvs6[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  72 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  83 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 101 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 120 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  750000, 139 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  750000, 159 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  760000, 180 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  770000, 200 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  780000, 221 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  790000, 242 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  800000, 264 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  810000, 287 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  820000, 308 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  830000, 333 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  840000, 356 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  850000, 380 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  860000, 404 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  870000, 430 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  875000, 456 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  885000, 482 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  895000, 510 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  905000, 538 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  915000, 565 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  920000, 596 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  930000, 627 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  940000, 659 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  950000, 691 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev0_2p3g_pvs0[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  74 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  780000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  790000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  800000, 164 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  810000, 184 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  820000, 206 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  830000, 227 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  840000, 249 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  850000, 271 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  865000, 295 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  875000, 318 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  890000, 342 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  900000, 365 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  915000, 392 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  925000, 416 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  940000, 442 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  955000, 469 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  970000, 497 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  985000, 525 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1000000, 554 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1015000, 583 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1030000, 613 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1045000, 642 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1060000, 663 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1060000, 675 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1075000, 708 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev0_2p3g_pvs1[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  74 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  785000, 164 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  795000, 184 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  805000, 206 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  815000, 227 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  825000, 249 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  835000, 271 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  850000, 295 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  860000, 318 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  870000, 342 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  885000, 365 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  895000, 392 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  905000, 416 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  920000, 442 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  935000, 469 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  950000, 497 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  965000, 525 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  980000, 554 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  995000, 583 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1005000, 613 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1020000, 642 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1035000, 663 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1035000, 675 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1050000, 708 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev0_2p3g_pvs2[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  74 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  760000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  770000, 164 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  780000, 184 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  790000, 206 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  800000, 227 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  810000, 249 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  820000, 271 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  830000, 295 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  840000, 318 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  850000, 342 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  865000, 365 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  875000, 392 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  885000, 416 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  900000, 442 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  915000, 469 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  930000, 497 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  945000, 525 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  955000, 554 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  970000, 583 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  980000, 613 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  995000, 642 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1010000, 663 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1010000, 675 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1025000, 708 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev0_2p3g_pvs3[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  74 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  750000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  755000, 164 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  765000, 184 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  775000, 206 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  785000, 227 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  795000, 249 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  805000, 271 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  815000, 295 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  825000, 318 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  835000, 342 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  850000, 365 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  860000, 392 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  870000, 416 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  885000, 442 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  900000, 469 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  910000, 497 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  925000, 525 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  935000, 554 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  945000, 583 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  960000, 613 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  970000, 642 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  985000, 663 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  985000, 675 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1000000, 708 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev0_2p3g_pvs4[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  74 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  750000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  750000, 164 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  755000, 184 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  765000, 206 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  775000, 227 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  785000, 249 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  795000, 271 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  805000, 295 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  815000, 318 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  825000, 342 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  835000, 365 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  845000, 392 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  855000, 416 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  870000, 442 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  885000, 469 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  895000, 497 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  905000, 525 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  915000, 554 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  925000, 583 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  935000, 613 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  950000, 642 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  960000, 663 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  960000, 675 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  975000, 708 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev0_2p3g_pvs5[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  725000,  74 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  725000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  725000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  725000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  725000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  735000, 164 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  745000, 184 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  755000, 206 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  765000, 227 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  775000, 249 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  785000, 271 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  795000, 295 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  805000, 318 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  815000, 342 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  825000, 365 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  835000, 392 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  845000, 416 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  855000, 442 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  865000, 469 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  875000, 497 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  885000, 525 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  895000, 554 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  905000, 583 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  915000, 613 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  930000, 642 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  940000, 663 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  940000, 675 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  950000, 708 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev0_2p3g_pvs6[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  725000,  74 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  725000,  85 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  725000, 104 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  725000, 124 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  725000, 144 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  725000, 164 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  735000, 184 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  745000, 206 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  755000, 227 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  765000, 249 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  775000, 271 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  785000, 295 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  795000, 318 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  805000, 342 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  815000, 365 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  825000, 392 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  835000, 416 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  845000, 442 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  850000, 469 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  860000, 497 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  870000, 525 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  880000, 554 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  890000, 583 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  895000, 613 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  905000, 642 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  915000, 663 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  915000, 675 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  925000, 708 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev0_2p5g_pvs0[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 125 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  800000, 145 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  810000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  820000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  830000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  840000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  850000, 251 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  860000, 273 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  870000, 296 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  880000, 319 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  890000, 342 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  900000, 365 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  910000, 390 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  920000, 415 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  930000, 439 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  945000, 465 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  960000, 493 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  975000, 521 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  990000, 549 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1005000, 579 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1020000, 608 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1035000, 638 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1050000, 667 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1050000, 667 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1065000, 700 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1080000, 734 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1095000, 769 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1100000, 785 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev0_2p5g_pvs1[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 125 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  800000, 145 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  800000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  800000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  805000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  815000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  825000, 251 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  835000, 273 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  845000, 296 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  855000, 319 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  865000, 342 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  875000, 365 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  885000, 390 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  895000, 415 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  905000, 439 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  920000, 465 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  935000, 493 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  950000, 521 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  965000, 549 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  980000, 579 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  995000, 608 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1010000, 638 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1025000, 667 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1025000, 667 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1040000, 700 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1055000, 734 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1070000, 769 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1075000, 785 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev0_2p5g_pvs2[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 125 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 145 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  780000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  790000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  800000, 251 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  810000, 273 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  820000, 296 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  830000, 319 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  840000, 342 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  850000, 365 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  860000, 390 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  870000, 415 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  880000, 439 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  895000, 465 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  910000, 493 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  925000, 521 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  940000, 549 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  955000, 579 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  970000, 608 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  985000, 638 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1000000, 667 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1000000, 667 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1015000, 700 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1030000, 734 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1045000, 769 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1050000, 785 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev0_2p5g_pvs3[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 125 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 145 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  775000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  775000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  780000, 251 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  785000, 273 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  795000, 296 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  805000, 319 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  815000, 342 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  825000, 365 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  835000, 390 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  845000, 415 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  855000, 439 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  870000, 465 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  885000, 493 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  900000, 521 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  915000, 549 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  930000, 579 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  945000, 608 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  960000, 638 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  975000, 667 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  975000, 667 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  990000, 700 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1005000, 734 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1020000, 769 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1025000, 785 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev0_2p5g_pvs4[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 125 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 145 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  775000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  775000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  775000, 251 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  775000, 273 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  775000, 296 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  780000, 319 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  790000, 342 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  800000, 365 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  810000, 390 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  820000, 415 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  830000, 439 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  845000, 465 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  860000, 493 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  875000, 521 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  890000, 549 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  905000, 579 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  920000, 608 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  935000, 638 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  950000, 667 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  950000, 667 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  965000, 700 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19),  980000, 734 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19),  995000, 769 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1000000, 785 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev0_2p5g_pvs5[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 125 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  750000, 145 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  750000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  750000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  750000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  750000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  750000, 251 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  750000, 273 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  750000, 296 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  760000, 319 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  770000, 342 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  780000, 365 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  790000, 390 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  800000, 415 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  810000, 439 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  820000, 465 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  835000, 493 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  850000, 521 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  865000, 549 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  880000, 579 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  895000, 608 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  910000, 638 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  925000, 667 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  925000, 667 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  940000, 700 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19),  955000, 734 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19),  970000, 769 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19),  975000, 785 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev0_2p5g_pvs6[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 125 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  750000, 145 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  750000, 165 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  750000, 186 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  750000, 208 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  750000, 229 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  750000, 251 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  750000, 273 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  750000, 296 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  750000, 319 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  755000, 342 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  765000, 365 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  775000, 390 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  785000, 415 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  795000, 439 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  805000, 465 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  815000, 493 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  825000, 521 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  840000, 549 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  855000, 579 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  870000, 608 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  885000, 638 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  900000, 667 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  900000, 667 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  915000, 700 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19),  930000, 734 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19),  945000, 769 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19),  950000, 785 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs0[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  810000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  820000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  830000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  840000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  850000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  860000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  870000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  880000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  890000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  900000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  910000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  920000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  930000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  940000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  950000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  965000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  980000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  995000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1010000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1025000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1040000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1055000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1070000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1070000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1085000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1100000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1115000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1120000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs1[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  810000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  820000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  830000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  840000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  850000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  860000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  870000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  880000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  890000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  900000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  910000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  920000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  930000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  940000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  955000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  970000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  985000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1000000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1015000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1030000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1045000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1060000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1060000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1075000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1090000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1105000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1110000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs2[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  800000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  810000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  820000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  830000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  840000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  850000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  860000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  870000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  880000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  890000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  900000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  910000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  920000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  930000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  945000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  960000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  975000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  990000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1005000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1020000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1035000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1050000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1050000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1065000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1080000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1095000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1100000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs3[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  800000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  800000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  810000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  820000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  830000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  840000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  850000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  860000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  870000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  880000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  890000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  900000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  910000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  920000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  935000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  950000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  965000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  980000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  995000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1010000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1025000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1040000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1040000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1055000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1070000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1085000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1090000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs4[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  800000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  800000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  800000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  810000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  820000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  830000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  840000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  850000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  860000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  870000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  880000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  890000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  900000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  910000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  925000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  940000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  955000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  970000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  985000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1000000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1015000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1030000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1030000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1045000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1060000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1075000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1080000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs5[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  800000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  800000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  800000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  800000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  810000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  820000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  830000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  840000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  850000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  860000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  870000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  880000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  890000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  900000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  915000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  930000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  945000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  960000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  975000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  990000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1005000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1020000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1020000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1035000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1050000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1065000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1070000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs6[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  780000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  790000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  800000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  810000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  820000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  830000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  840000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  850000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  860000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  870000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  880000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  890000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  905000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  920000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  935000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  950000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  965000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  980000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  995000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1010000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1010000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1025000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1040000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1055000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1060000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs7[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  780000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  790000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  800000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  810000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  820000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  830000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  840000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  850000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  860000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  870000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  880000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  895000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  910000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  925000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  940000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  955000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  970000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  985000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1000000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1000000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1015000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1030000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1045000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1050000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs8[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  775000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  780000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  790000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  800000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  810000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  820000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  830000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  840000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  850000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  860000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  870000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  885000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  900000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  915000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  930000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  945000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  960000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  975000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  990000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  990000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1005000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1020000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1035000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1040000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs9[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  775000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  775000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  780000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  790000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  800000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  810000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  820000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  830000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  840000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  850000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  860000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  875000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  890000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  905000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  920000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  935000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  950000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  965000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  980000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  980000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  995000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1010000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1025000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1030000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs10[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  775000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  775000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  775000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  780000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  790000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  800000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  810000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  820000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  830000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  840000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  850000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  865000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  880000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  895000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  910000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  925000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  940000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  955000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  970000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  970000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  985000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19), 1000000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1015000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1020000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs11[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  775000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  775000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  775000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  775000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  780000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  790000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  800000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  810000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  820000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  830000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  840000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  855000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  870000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  885000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  900000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  915000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  930000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  945000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  960000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  960000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  975000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19),  990000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19), 1005000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1010000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs12[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  775000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  775000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  775000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  775000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  775000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  780000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  790000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  800000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  810000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  820000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  830000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  845000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  860000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  875000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  890000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  905000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  920000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  935000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  950000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  950000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  965000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19),  980000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19),  995000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19), 1000000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs13[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  775000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  775000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  775000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  775000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  775000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  775000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  780000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  790000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  800000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  810000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  820000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  835000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  850000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  865000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  880000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  895000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  910000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  925000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  940000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  940000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  955000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19),  970000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19),  985000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19),  990000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs14[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  750000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  750000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  750000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  750000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  750000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  750000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  750000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  750000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  760000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  770000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  780000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  790000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  800000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  810000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  825000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  840000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  855000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  870000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  885000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  900000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  915000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  930000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  930000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  945000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19),  960000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19),  975000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19),  980000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p5g_pvs15[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 106 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 126 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  750000, 147 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  750000, 168 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  750000, 189 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  750000, 211 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  750000, 233 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  750000, 256 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  750000, 278 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  750000, 301 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  750000, 324 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  760000, 348 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  770000, 372 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  780000, 396 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  790000, 421 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  800000, 446 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  815000, 473 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  830000, 501 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  845000, 529 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  860000, 558 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  875000, 588 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  890000, 617 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  905000, 649 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  920000, 682 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  920000, 682 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  935000, 716 },
	{ 0, { 2342400, HFPLL, 1, 122 }, L2(19),  950000, 751 },
	{ 0, { 2419200, HFPLL, 1, 126 }, L2(19),  965000, 786 },
	{ 1, { 2457600, HFPLL, 1, 128 }, L2(19),  970000, 802 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs0[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  810000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  820000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  830000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  840000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  850000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  860000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  870000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  880000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  890000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  900000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  910000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  920000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  930000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  940000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  955000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  970000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  985000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17), 1000000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18), 1015000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1030000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1045000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1060000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1075000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1090000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1105000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1105000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1120000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs1[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  810000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  820000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  830000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  840000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  850000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  860000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  870000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  880000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  890000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  900000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  910000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  920000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  930000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  945000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  960000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  975000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  990000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18), 1005000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1020000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1035000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1050000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1065000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1080000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1095000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1095000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1110000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs2[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  810000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  820000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  830000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  840000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  850000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  860000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  870000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  880000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  890000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  900000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  910000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  920000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  935000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  950000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  965000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  980000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  995000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1010000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1025000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1040000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1055000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1070000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1085000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1085000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1100000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs3[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  810000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  820000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  830000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  840000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  850000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  860000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  870000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  880000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  890000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  900000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  910000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  925000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  940000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  955000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  970000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  985000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18), 1000000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1015000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1030000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1045000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1060000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1075000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1075000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1090000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs4[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  800000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  810000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  820000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  830000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  840000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  850000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  860000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  870000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  880000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  890000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  900000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  915000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  930000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  945000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  960000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  975000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  990000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18), 1005000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1020000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1035000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1050000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1065000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1065000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1080000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs5[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  800000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  800000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  800000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  800000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  800000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  800000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  810000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  820000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  830000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  840000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  850000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  860000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  870000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  880000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  890000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  905000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  920000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  935000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  950000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  965000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  980000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  995000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1010000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1025000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1040000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1055000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1055000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1070000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs6[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  780000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  790000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  800000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  810000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  820000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  830000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  840000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  850000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  860000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  870000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  880000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  895000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  910000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  925000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  940000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  955000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  970000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  985000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19), 1000000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1015000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1030000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1045000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1045000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1060000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs7[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  780000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  790000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  800000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  810000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  820000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  830000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  840000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  850000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  860000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  870000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  885000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  900000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  915000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  930000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  945000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  960000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  975000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  990000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19), 1005000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1020000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1035000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1035000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1050000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs8[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  780000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  790000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  800000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  810000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  820000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  830000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  840000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  850000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  860000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  875000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  890000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  905000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  920000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  935000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  950000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  965000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  980000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  995000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1010000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1025000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1025000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1040000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs9[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  780000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  790000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  800000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  810000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  820000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  830000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  840000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  850000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  865000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  880000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  895000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  910000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  925000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  940000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  955000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  970000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  985000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19), 1000000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1015000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1015000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1030000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs10[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  775000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  780000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  790000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  800000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  810000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  820000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  830000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  840000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  855000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  870000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  885000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  900000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  915000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  930000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  945000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  960000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  975000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  990000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19), 1005000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19), 1005000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1020000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs11[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  775000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  775000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  780000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  790000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  800000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  810000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  820000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  830000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  845000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  860000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  875000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  890000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  905000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  920000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  935000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  950000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  965000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  980000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  995000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  995000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1010000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs12[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  775000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  775000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  775000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  780000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  790000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  800000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  810000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  820000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  835000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  850000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  865000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  880000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  895000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  910000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  925000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  940000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  955000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  970000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  985000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  985000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19), 1000000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs13[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  775000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  775000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  775000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  775000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  775000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  775000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  775000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  775000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  775000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  775000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  775000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  780000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  790000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  800000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  810000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  825000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  840000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  855000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  870000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  885000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  900000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  915000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  930000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  945000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  960000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  975000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  975000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  990000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs14[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  750000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  750000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  750000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  750000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  750000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  750000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  760000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  770000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  780000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  790000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  800000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  815000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  830000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  845000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  860000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  875000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  890000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  905000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  920000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  935000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  950000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  965000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  965000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  980000, 738 },
	{ 0, { 0 } }
};

static struct acpu_level pro_rev1_2p3g_pvs15[] __initdata = {
	{ 1, {  300000, PLL_0, 0,   0 },  L2(0),  750000,  76 },
	{ 0, {  345600, HFPLL, 2,  36 },  L2(1),  750000,  87 },
	{ 1, {  422400, HFPLL, 2,  44 },  L2(2),  750000, 108 },
	{ 0, {  499200, HFPLL, 2,  52 },  L2(2),  750000, 129 },
	{ 0, {  576000, HFPLL, 1,  30 },  L2(3),  750000, 150 },
	{ 1, {  652800, HFPLL, 1,  34 },  L2(3),  750000, 171 },
	{ 1, {  729600, HFPLL, 1,  38 },  L2(4),  750000, 193 },
	{ 0, {  806400, HFPLL, 1,  42 },  L2(4),  750000, 215 },
	{ 1, {  883200, HFPLL, 1,  46 },  L2(4),  750000, 237 },
	{ 1, {  960000, HFPLL, 1,  50 },  L2(9),  750000, 260 },
	{ 1, { 1036800, HFPLL, 1,  54 }, L2(10),  750000, 282 },
	{ 0, { 1113600, HFPLL, 1,  58 }, L2(10),  760000, 306 },
	{ 1, { 1190400, HFPLL, 1,  62 }, L2(10),  770000, 330 },
	{ 1, { 1267200, HFPLL, 1,  66 }, L2(13),  780000, 354 },
	{ 0, { 1344000, HFPLL, 1,  70 }, L2(14),  790000, 378 },
	{ 0, { 1420800, HFPLL, 1,  74 }, L2(15),  805000, 404 },
	{ 1, { 1497600, HFPLL, 1,  78 }, L2(16),  820000, 431 },
	{ 1, { 1574400, HFPLL, 1,  82 }, L2(17),  835000, 458 },
	{ 0, { 1651200, HFPLL, 1,  86 }, L2(17),  850000, 486 },
	{ 1, { 1728000, HFPLL, 1,  90 }, L2(18),  865000, 515 },
	{ 0, { 1804800, HFPLL, 1,  94 }, L2(18),  880000, 543 },
	{ 0, { 1881600, HFPLL, 1,  98 }, L2(18),  895000, 572 },
	{ 1, { 1958400, HFPLL, 1, 102 }, L2(19),  910000, 604 },
	{ 0, { 2035200, HFPLL, 1, 106 }, L2(19),  925000, 636 },
	{ 0, { 2112000, HFPLL, 1, 110 }, L2(19),  940000, 669 },
	{ 0, { 2150400, HFPLL, 1, 112 }, L2(19),  955000, 703 },
	{ 0, { 2188800, HFPLL, 1, 114 }, L2(19),  955000, 703 },
	{ 1, { 2265600, HFPLL, 1, 118 }, L2(19),  970000, 738 },
	{ 0, { 0 } }
};

static struct pvs_table pvs_v2[NUM_PVS_REVS][NUM_SPEED_BINS][NUM_PVS] __initdata = {
	/* 8974v2 2.0GHz Parts */
	[0][0][0] = { acpu_freq_tbl_2g_pvs0, sizeof(acpu_freq_tbl_2g_pvs0) },
	[0][0][1] = { acpu_freq_tbl_2g_pvs1, sizeof(acpu_freq_tbl_2g_pvs1) },
	[0][0][2] = { acpu_freq_tbl_2g_pvs2, sizeof(acpu_freq_tbl_2g_pvs2) },
	[0][0][3] = { acpu_freq_tbl_2g_pvs3, sizeof(acpu_freq_tbl_2g_pvs3) },
	[0][0][4] = { acpu_freq_tbl_2g_pvs4, sizeof(acpu_freq_tbl_2g_pvs4) },
	[0][0][5] = { acpu_freq_tbl_2g_pvs5, sizeof(acpu_freq_tbl_2g_pvs5) },
	[0][0][6] = { acpu_freq_tbl_2g_pvs6, sizeof(acpu_freq_tbl_2g_pvs6) },
	[0][0][7] = { acpu_freq_tbl_2g_pvs6, sizeof(acpu_freq_tbl_2g_pvs6) },

	/* 8974v2 2.3GHz Parts */
	[0][1][0] = { acpu_freq_tbl_2p3g_pvs0, sizeof(acpu_freq_tbl_2p3g_pvs0) },
	[0][1][1] = { acpu_freq_tbl_2p3g_pvs1, sizeof(acpu_freq_tbl_2p3g_pvs1) },
	[0][1][2] = { acpu_freq_tbl_2p3g_pvs2, sizeof(acpu_freq_tbl_2p3g_pvs2) },
	[0][1][3] = { acpu_freq_tbl_2p3g_pvs3, sizeof(acpu_freq_tbl_2p3g_pvs3) },
	[0][1][4] = { acpu_freq_tbl_2p3g_pvs4, sizeof(acpu_freq_tbl_2p3g_pvs4) },
	[0][1][5] = { acpu_freq_tbl_2p3g_pvs5, sizeof(acpu_freq_tbl_2p3g_pvs5) },
	[0][1][6] = { acpu_freq_tbl_2p3g_pvs6, sizeof(acpu_freq_tbl_2p3g_pvs6) },
	[0][1][7] = { acpu_freq_tbl_2p3g_pvs6, sizeof(acpu_freq_tbl_2p3g_pvs6) },

	/* 8974v2 2.2GHz Parts */
	[0][2][0] = { acpu_freq_tbl_2p2g_pvs0, sizeof(acpu_freq_tbl_2p2g_pvs0) },
	[0][2][1] = { acpu_freq_tbl_2p2g_pvs1, sizeof(acpu_freq_tbl_2p2g_pvs1) },
	[0][2][2] = { acpu_freq_tbl_2p2g_pvs2, sizeof(acpu_freq_tbl_2p2g_pvs2) },
	[0][2][3] = { acpu_freq_tbl_2p2g_pvs3, sizeof(acpu_freq_tbl_2p2g_pvs3) },
	[0][2][4] = { acpu_freq_tbl_2p2g_pvs4, sizeof(acpu_freq_tbl_2p2g_pvs4) },
	[0][2][5] = { acpu_freq_tbl_2p2g_pvs5, sizeof(acpu_freq_tbl_2p2g_pvs5) },
	[0][2][6] = { acpu_freq_tbl_2p2g_pvs6, sizeof(acpu_freq_tbl_2p2g_pvs6) },
	[0][2][7] = { acpu_freq_tbl_2p2g_pvs6, sizeof(acpu_freq_tbl_2p2g_pvs6) },
};

static struct pvs_table pvs_pro[NUM_PVS_REVS][NUM_SPEED_BINS][NUM_PVS] __initdata = {
	/* 2.0 GHz is not used on 8974Pro */
	[0][0][0] = { acpu_freq_tbl_2g_pvs0, sizeof(acpu_freq_tbl_2g_pvs0) },
	[0][0][1] = { acpu_freq_tbl_2g_pvs1, sizeof(acpu_freq_tbl_2g_pvs1) },
	[0][0][2] = { acpu_freq_tbl_2g_pvs2, sizeof(acpu_freq_tbl_2g_pvs2) },
	[0][0][3] = { acpu_freq_tbl_2g_pvs3, sizeof(acpu_freq_tbl_2g_pvs3) },
	[0][0][4] = { acpu_freq_tbl_2g_pvs4, sizeof(acpu_freq_tbl_2g_pvs4) },
	[0][0][5] = { acpu_freq_tbl_2g_pvs5, sizeof(acpu_freq_tbl_2g_pvs5) },
	[0][0][6] = { acpu_freq_tbl_2g_pvs6, sizeof(acpu_freq_tbl_2g_pvs6) },
	[0][0][7] = { acpu_freq_tbl_2g_pvs6, sizeof(acpu_freq_tbl_2g_pvs6) },

	/* 8974Pro AB 2.3GHz */
	[0][1][0] = { pro_rev0_2p3g_pvs0, sizeof(pro_rev0_2p3g_pvs0) },
	[0][1][1] = { pro_rev0_2p3g_pvs1, sizeof(pro_rev0_2p3g_pvs1) },
	[0][1][2] = { pro_rev0_2p3g_pvs2, sizeof(pro_rev0_2p3g_pvs2) },
	[0][1][3] = { pro_rev0_2p3g_pvs3, sizeof(pro_rev0_2p3g_pvs3) },
	[0][1][4] = { pro_rev0_2p3g_pvs4, sizeof(pro_rev0_2p3g_pvs4) },
	[0][1][5] = { pro_rev0_2p3g_pvs5, sizeof(pro_rev0_2p3g_pvs5) },
	[0][1][6] = { pro_rev0_2p3g_pvs6, sizeof(pro_rev0_2p3g_pvs6) },
	[0][1][7] = { pro_rev0_2p3g_pvs6, sizeof(pro_rev0_2p3g_pvs6) },

	/* 2.2GHz is not used on 8974Pro */
	[0][2][0] = { acpu_freq_tbl_2p2g_pvs0, sizeof(acpu_freq_tbl_2p2g_pvs0) },
	[0][2][1] = { acpu_freq_tbl_2p2g_pvs1, sizeof(acpu_freq_tbl_2p2g_pvs1) },
	[0][2][2] = { acpu_freq_tbl_2p2g_pvs2, sizeof(acpu_freq_tbl_2p2g_pvs2) },
	[0][2][3] = { acpu_freq_tbl_2p2g_pvs3, sizeof(acpu_freq_tbl_2p2g_pvs3) },
	[0][2][4] = { acpu_freq_tbl_2p2g_pvs4, sizeof(acpu_freq_tbl_2p2g_pvs4) },
	[0][2][5] = { acpu_freq_tbl_2p2g_pvs5, sizeof(acpu_freq_tbl_2p2g_pvs5) },
	[0][2][6] = { acpu_freq_tbl_2p2g_pvs6, sizeof(acpu_freq_tbl_2p2g_pvs6) },
	[0][2][7] = { acpu_freq_tbl_2p2g_pvs6, sizeof(acpu_freq_tbl_2p2g_pvs6) },

	/* 8974Pro AC 2.5GHz */
	[0][3][0] = { pro_rev0_2p5g_pvs0, sizeof(pro_rev0_2p5g_pvs0) },
	[0][3][1] = { pro_rev0_2p5g_pvs1, sizeof(pro_rev0_2p5g_pvs1) },
	[0][3][2] = { pro_rev0_2p5g_pvs2, sizeof(pro_rev0_2p5g_pvs2) },
	[0][3][3] = { pro_rev0_2p5g_pvs3, sizeof(pro_rev0_2p5g_pvs3) },
	[0][3][4] = { pro_rev0_2p5g_pvs4, sizeof(pro_rev0_2p5g_pvs4) },
	[0][3][5] = { pro_rev0_2p5g_pvs5, sizeof(pro_rev0_2p5g_pvs5) },
	[0][3][6] = { pro_rev0_2p5g_pvs6, sizeof(pro_rev0_2p5g_pvs6) },
	[0][3][7] = { pro_rev0_2p5g_pvs6, sizeof(pro_rev0_2p5g_pvs6) },

	/* 8974Pro AB 2.3GHz */
	[1][1][0] = { pro_rev1_2p3g_pvs0, sizeof(pro_rev1_2p3g_pvs0) },
	[1][1][1] = { pro_rev1_2p3g_pvs1, sizeof(pro_rev1_2p3g_pvs1) },
	[1][1][2] = { pro_rev1_2p3g_pvs2, sizeof(pro_rev1_2p3g_pvs2) },
	[1][1][3] = { pro_rev1_2p3g_pvs3, sizeof(pro_rev1_2p3g_pvs3) },
	[1][1][4] = { pro_rev1_2p3g_pvs4, sizeof(pro_rev1_2p3g_pvs4) },
	[1][1][5] = { pro_rev1_2p3g_pvs5, sizeof(pro_rev1_2p3g_pvs5) },
	[1][1][6] = { pro_rev1_2p3g_pvs6, sizeof(pro_rev1_2p3g_pvs6) },
	[1][1][7] = { pro_rev1_2p3g_pvs7, sizeof(pro_rev1_2p3g_pvs7) },
	[1][1][8] = { pro_rev1_2p3g_pvs8, sizeof(pro_rev1_2p3g_pvs8) },
	[1][1][9] = { pro_rev1_2p3g_pvs9, sizeof(pro_rev1_2p3g_pvs9) },
	[1][1][10] = { pro_rev1_2p3g_pvs10, sizeof(pro_rev1_2p3g_pvs10) },
	[1][1][11] = { pro_rev1_2p3g_pvs11, sizeof(pro_rev1_2p3g_pvs11) },
	[1][1][12] = { pro_rev1_2p3g_pvs12, sizeof(pro_rev1_2p3g_pvs12) },
	[1][1][13] = { pro_rev1_2p3g_pvs13, sizeof(pro_rev1_2p3g_pvs13) },
	[1][1][14] = { pro_rev1_2p3g_pvs14, sizeof(pro_rev1_2p3g_pvs14) },
	[1][1][15] = { pro_rev1_2p3g_pvs15, sizeof(pro_rev1_2p3g_pvs15) },

	/* 8974Pro AC 2.5GHz */
	[1][3][0] = { pro_rev1_2p5g_pvs0, sizeof(pro_rev1_2p5g_pvs0) },
	[1][3][1] = { pro_rev1_2p5g_pvs1, sizeof(pro_rev1_2p5g_pvs1) },
	[1][3][2] = { pro_rev1_2p5g_pvs2, sizeof(pro_rev1_2p5g_pvs2) },
	[1][3][3] = { pro_rev1_2p5g_pvs3, sizeof(pro_rev1_2p5g_pvs3) },
	[1][3][4] = { pro_rev1_2p5g_pvs4, sizeof(pro_rev1_2p5g_pvs4) },
	[1][3][5] = { pro_rev1_2p5g_pvs5, sizeof(pro_rev1_2p5g_pvs5) },
	[1][3][6] = { pro_rev1_2p5g_pvs6, sizeof(pro_rev1_2p5g_pvs6) },
	[1][3][7] = { pro_rev1_2p5g_pvs7, sizeof(pro_rev1_2p5g_pvs7) },
	[1][3][8] = { pro_rev1_2p5g_pvs8, sizeof(pro_rev1_2p5g_pvs8) },
	[1][3][9] = { pro_rev1_2p5g_pvs9, sizeof(pro_rev1_2p5g_pvs9) },
	[1][3][10] = { pro_rev1_2p5g_pvs10, sizeof(pro_rev1_2p5g_pvs10) },
	[1][3][11] = { pro_rev1_2p5g_pvs11, sizeof(pro_rev1_2p5g_pvs11) },
	[1][3][12] = { pro_rev1_2p5g_pvs12, sizeof(pro_rev1_2p5g_pvs12) },
	[1][3][13] = { pro_rev1_2p5g_pvs13, sizeof(pro_rev1_2p5g_pvs13) },
	[1][3][14] = { pro_rev1_2p5g_pvs14, sizeof(pro_rev1_2p5g_pvs14) },
	[1][3][15] = { pro_rev1_2p5g_pvs15, sizeof(pro_rev1_2p5g_pvs15) },
};

static struct msm_bus_scale_pdata bus_scale_data __initdata = {
	.usecase = bw_level_tbl,
	.num_usecases = ARRAY_SIZE(bw_level_tbl),
	.active_only = 1,
	.name = "acpuclk-8974",
};

static struct acpuclk_krait_params acpuclk_8974_params __initdata = {
	.scalable = scalable,
	.scalable_size = sizeof(scalable),
	.hfpll_data = &hfpll_data,
	.l2_freq_tbl = l2_freq_tbl,
	.l2_freq_tbl_size = sizeof(l2_freq_tbl),
	.bus_scale = &bus_scale_data,
	.pte_efuse_phys = 0xFC4B80B0,
	.get_bin_info = get_krait_bin_format_b,
	.stby_khz = 300000,
};

#define cpu_is_msm8974pro() (cpu_is_msm8974pro_aa() || cpu_is_msm8974pro_ab() \
			     || cpu_is_msm8974pro_ac())

static int __init acpuclk_8974_probe(struct platform_device *pdev)
{
	if (cpu_is_msm8974pro())
		acpuclk_8974_params.pvs_tables = pvs_pro;
	else
		acpuclk_8974_params.pvs_tables = pvs_v2;

	return acpuclk_krait_init(&pdev->dev, &acpuclk_8974_params);
}

static struct of_device_id acpuclk_8974_match_table[] = {
	{ .compatible = "qcom,acpuclk-8974" },
	{}
};

static struct platform_driver acpuclk_8974_driver = {
	.driver = {
		.name = "acpuclk-8974",
		.of_match_table = acpuclk_8974_match_table,
		.owner = THIS_MODULE,
	},
};

static int __init acpuclk_8974_init(void)
{
	return platform_driver_probe(&acpuclk_8974_driver,
				     acpuclk_8974_probe);
}
device_initcall(acpuclk_8974_init);
