#!/system/bin/sh
#----------------------------------------------------
# Yank555.lu - Kernel options init.d script generator
#----------------------------------------------------

script_path="/tmp/Yank555.lu/script"
script_name="99z_kernel"
log_file="/data/kernel-script.log"
sub_scripts_path="$script_path/sub-scripts"
props_path="/tmp/aroma"
bin_path="/tmp/Yank555.lu/bin"

# Start making the script header -----------------------------------------------------------------

$bin_path/echo "----------------------------------------------------" >$log_file
$bin_path/echo "Kernel options init.d script generator by Yank555.lu" >>$log_file
$bin_path/echo "----------------------------------------------------" >>$log_file
$bin_path/date "+Script generated on %d/%m/%Y at %k:%M" >>$log_file
$bin_path/echo "----------------------------------------------------" >>$log_file
$bin_path/echo "" >>$log_file
$bin_path/echo "1) Preparing init.d script header" >>$log_file

$bin_path/rm $script_path/$script_name >>$log_file
$bin_path/cp $sub_scripts_path/header $script_path/$script_name >>$log_file
$bin_path/date "+# Script generated on %d/%m/%Y at %k:%M" >>$script_path/$script_name
$bin_path/echo "#----------------------------------------------------" >>$script_path/$script_name
$bin_path/echo "" >>$script_path/$script_name

$bin_path/echo "" >>$log_file

# Add CPU configuration --------------------------------------------------------------------------

$bin_path/echo "2) CPU configuration" >>$log_file

if [ "`$bin_path/grep selected.1 $props_path/cpu.prop | $bin_path/awk -F= '{print $2;}'`" != "" ]
  then
    $bin_path/echo "     CPU min        = `$bin_path/grep selected.1 $props_path/cpu.prop | $bin_path/awk -F= '{print $2;}'`" >>$log_file
    $bin_path/cat $sub_scripts_path/cpu/1.`$bin_path/grep selected.1 $props_path/cpu.prop | $bin_path/awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`$bin_path/grep selected.2 $props_path/cpu.prop | $bin_path/awk -F= '{print $2;}'`" != "" ]
  then
    $bin_path/echo "     CPU max        = `$bin_path/grep selected.2 $props_path/cpu.prop | $bin_path/awk -F= '{print $2;}'`" >>$log_file
    $bin_path/cat $sub_scripts_path/cpu/2.`$bin_path/grep selected.2 $props_path/cpu.prop | $bin_path/awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`$bin_path/grep selected.3 $props_path/cpu.prop | $bin_path/awk -F= '{print $2;}'`" != "" ]
  then
    $bin_path/echo "     Screen off max = `$bin_path/grep selected.3 $props_path/cpu.prop | $bin_path/awk -F= '{print $2;}'`" >>$log_file
    $bin_path/cat $sub_scripts_path/cpu/3.`$bin_path/grep selected.3 $props_path/cpu.prop | $bin_path/awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

$bin_path/echo "" >>$log_file

# Add Intellidemand governor settings ------------------------------------------------------------

$bin_path/echo "3) Intellidemand governor settings" >>$log_file

if [ "`$bin_path/grep selected.2 $props_path/cpu.prop | $bin_path/awk -F= '{print $2;}'`" != "" ]
  then
    $bin_path/echo "     active max   = `$bin_path/grep selected.2 $props_path/cpu.prop | $bin_path/awk -F= '{print $2;}'`" >>$log_file
    $bin_path/cat $sub_scripts_path/intellidemand/0.`$bin_path/grep selected.2 $props_path/cpu.prop | $bin_path/awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Correcting potential wrong user input in Aroma
#
# user input
user_cpu_max=`$bin_path/grep selected.2 $props_path/cpu.prop | $bin_path/awk -F= '{print $2;}'` >>$log_file
user_inactive_max=`$bin_path/grep selected.1 $props_path/intellidemand.prop | $bin_path/awk -F= '{print $2;}'` >>$log_file
user_two_phase=`$bin_path/grep selected.2 $props_path/intellidemand.prop | $bin_path/awk -F= '{print $2;}'` >>$log_file
# corrected selections
inactive_max=`$bin_path/awk -v user_cpu_max="$user_cpu_max" -v user_inactive_max="$user_inactive_max" 'BEGIN { if ( user_inactive_max >= user_cpu_max + 5 ) { print user_cpu_max + 4 } else { print user_inactive_max } }'`
two_phase=`$bin_path/awk -v inactive_max="$inactive_max" -v user_two_phase="$user_two_phase" 'BEGIN { if ( user_two_phase >= inactive_max ) { print inactive_max - 1 } else { print user_two_phase } }'`

if [ "$inactive_max" != "" ]
  then
    $bin_path/echo "     inactive max = $inactive_max" >>$log_file
    $bin_path/cat $sub_scripts_path/intellidemand/1.$inactive_max >>$script_path/$script_name
fi;

if [ "$two_phase" != "" ]
  then
    $bin_path/echo "     two-phase    = $two_phase" >>$log_file
    $bin_path/cat $sub_scripts_path/intellidemand/2.$two_phase >>$script_path/$script_name
fi;

$bin_path/echo "" >>$log_file

# Add CPU undervolting ---------------------------------------------------------------------------

echo "4) CPU undervolting" >>$log_file

if [ "`$bin_path/grep selected.1 $props_path/undervolting.prop | $bin_path/awk -F= '{print $2;}'`" != "" ]
  then
    $bin_path/echo "     Level = `$bin_path/grep selected.1 $props_path/undervolting.prop | $bin_path/awk -F= '{print $2;}'`" >>$log_file
    $bin_path/cat $sub_scripts_path/undervolting/1.`$bin_path/grep selected.1 $props_path/undervolting.prop | $bin_path/awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

$bin_path/echo "" >>$log_file

# Add GPU configuration --------------------------------------------------------------------------

$bin_path/echo "5) GPU configuration" >>$log_file

if [ "`$bin_path/grep selected.1 $props_path/gpu.prop | $bin_path/awk -F= '{print $2;}'`" != "" ]
  then
    $bin_path/echo "     GPU 3D OC = `$bin_path/grep selected.1 $props_path/gpu.prop | $bin_path/awk -F= '{print $2;}'`" >>$log_file
    $bin_path/cat $sub_scripts_path/gpu/1.`$bin_path/grep selected.1 $props_path/gpu.prop | $bin_path/awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

$bin_path/echo "" >>$log_file

# Add Mods configuration -------------------------------------------------------------------------

$bin_path/echo "6) Mods configuration" >>$log_file

if [ "`$bin_path/grep selected.1 $props_path/mods.prop | $bin_path/awk -F= '{print $2;}'`" != "" ]
  then
    $bin_path/echo "     USB Fast Charge  = `$bin_path/grep selected.1 $props_path/mods.prop | $bin_path/awk -F= '{print $2;}'`" >>$log_file
    $bin_path/cat $sub_scripts_path/mods/1.`$bin_path/grep selected.1 $props_path/mods.prop | $bin_path/awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`$bin_path/grep selected.2 $props_path/mods.prop | $bin_path/awk -F= '{print $2;}'`" != "" ]
  then
    $bin_path/echo "     Hardswap         = `$bin_path/grep selected.2 $props_path/mods.prop | $bin_path/awk -F= '{print $2;}'`" >>$log_file
    $bin_path/cat $sub_scripts_path/mods/2.`$bin_path/grep selected.2 $props_path/mods.prop | $bin_path/awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`$bin_path/grep selected.3 $props_path/mods.prop | $bin_path/awk -F= '{print $2;}'`" != "" ]
  then
    $bin_path/echo "     zRam             = `$bin_path/grep selected.3 $props_path/mods.prop | $bin_path/awk -F= '{print $2;}'`" >>$log_file
    $bin_path/cat $sub_scripts_path/mods/3.`$bin_path/grep selected.3 $props_path/mods.prop | $bin_path/awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`$bin_path/grep selected.4 $props_path/mods.prop | $bin_path/awk -F= '{print $2;}'`" != "" ]
  then
    $bin_path/echo "     Vsync            = `$bin_path/grep selected.4 $props_path/mods.prop | $bin_path/awk -F= '{print $2;}'`" >>$log_file
    $bin_path/cat $sub_scripts_path/mods/4.`$bin_path/grep selected.4 $props_path/mods.prop | $bin_path/awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Add Android Low Memory Killer configuration ----------------------------------------------------

if [ "`$bin_path/grep selected.1 $props_path/lmk.prop | $bin_path/awk -F= '{print $2;}'`" != "" ]
  then
    $bin_path/echo "     Android LMK = `$bin_path/grep selected.1 $props_path/lmk.prop | $bin_path/awk -F= '{print $2;}'`" >>$log_file
    $bin_path/cat $sub_scripts_path/lmk/1.`$bin_path/grep selected.1 $props_path/lmk.prop | $bin_path/awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

# Add MMC I/O configuration ----------------------------------------------------------------------

if [ "`$bin_path/grep selected.1 $props_path/io.prop | $bin_path/awk -F= '{print $2;}'`" != "" ]
  then
    $bin_path/echo "     ReadAhead size  = `$bin_path/grep selected.1 $props_path/io.prop | $bin_path/awk -F= '{print $2;}'`" >>$log_file
    $bin_path/cat $sub_scripts_path/io/1.`$bin_path/grep selected.1 $props_path/io.prop | $bin_path/awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

if [ "`$bin_path/grep selected.2 $props_path/io.prop | $bin_path/awk -F= '{print $2;}'`" != "" ]
  then
    $bin_path/echo "     I/O scheduler   = `$bin_path/grep selected.2 $props_path/io.prop | $bin_path/awk -F= '{print $2;}'`" >>$log_file
    $bin_path/cat $sub_scripts_path/io/2.`$bin_path/grep selected.2 $props_path/io.prop | $bin_path/awk -F= '{print $2;}'` >>$script_path/$script_name
fi;

$bin_path/echo "" >>$log_file

$bin_path/cat $sub_scripts_path/footer >>$script_path/$script_name

# Installing generated script to system init.d ---------------------------------------------------

$bin_path/echo "7) Installing generated script to /system/etc/init.d" >>$log_file

$bin_path/rm /system/etc/init.d/$script_name
$bin_path/cp $script_path/$script_name /system/etc/init.d/$script_name
$bin_path/chmod 755 /system/etc/init.d/$script_name
$bin_path/chown 0:2000 /system/etc/init.d/$script_name

# All done for this step -------------------------------------------------------------------------