#!/system/bin/sh
#---------------------------------
# Hard Swap Flasher by Yank555.lu
#---------------------------------

log_file="/data/hardswap.log"
bin_path="/tmp/Yank555.lu/bin"
script_path="/tmp/Yank555.lu/swap/install"
feedback_file="$script_path/hardswap.prop"
sdcard_device="/dev/block/mmcblk1"
swap_partition=`$bin_path/fdisk -l $sdcard_device | $bin_path/grep swap | $bin_path/awk '{print $1;}'`

# Remove any prior logfiles / feedback files
$bin_path/rm $log_file
$bin_path/rm $feedback_file

$bin_path/echo "------------------------------------------------" > $log_file
$bin_path/echo "     Hard Swap Flasher by Yank555.lu - v2.3     " >> $log_file
$bin_path/echo "------------------------------------------------" >> $log_file
$bin_path/echo "SD-card device = $sdcard_device" >> $log_file
$bin_path/echo " " >> $log_file
$bin_path/echo "Paratition table for SD-card :" >> $log_file
$bin_path/echo "------------------------------" >> $log_file
$bin_path/fdisk -l $sdcard_device >> $log_file
$bin_path/echo " " >> $log_file
$bin_path/echo "Swap partition = $swap_partition" >> $log_file
$bin_path/echo " " >> $log_file

if [ "$swap_partition" = "" ];
  then

    $bin_path/echo "swap.present = no" >> $feedback_file

    $bin_path/echo "No swap partion present on SD-card ... aborting !" >> $log_file

  else

    $bin_path/echo "swap.present = yes" >> $feedback_file
    $bin_path/echo "swap.device = $swap_partition" >> $feedback_file

    $bin_path/echo "- formating swap partition '$swap_partition'" >> $log_file
    $bin_path/mkswap $swap_partition >> $log_file
    $bin_path/echo " " >> $log_file

    $bin_path/echo "swap.formated = yes" >> $feedback_file

    $bin_path/echo "- copying swap activation script to /system/etc/init.d" >> $log_file
    $bin_path/echo " " >> $log_file
    $bin_path/cp /tmp/Yank555.lu/swap/init.d/98swap /system/etc/init.d/98swap
    $bin_path/chmod 755 /system/etc/init.d/98swap
    $bin_path/chown 0:2000 /system/etc/init.d/98swap
    $bin_path/echo "done." >> $log_file

    $bin_path/echo "swap.scriptinstalled = yes" >> $feedback_file

fi;